/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.telemetry.TelemetryAnalyzerPerformance;
import org.sonarsource.sonarlint.core.telemetry.TelemetryNotificationsCounter;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryAnalyzerPerformancePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryNotificationsCounterPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryNotificationsPayload;

class TelemetryUtils {
    private TelemetryUtils() {
    }

    static boolean dayChanged(@Nullable LocalDate date) {
        return date == null || !date.equals(LocalDate.now());
    }

    static TelemetryAnalyzerPerformancePayload[] toPayload(Map<String, TelemetryAnalyzerPerformance> analyzers) {
        return (TelemetryAnalyzerPerformancePayload[])analyzers.entrySet().stream().map(TelemetryUtils::toPayload).toArray(TelemetryAnalyzerPerformancePayload[]::new);
    }

    private static TelemetryAnalyzerPerformancePayload toPayload(Map.Entry<String, TelemetryAnalyzerPerformance> entry) {
        TelemetryAnalyzerPerformance analyzerPerformance = entry.getValue();
        String language = entry.getKey();
        int analysisCount = analyzerPerformance.analysisCount();
        Map distribution = analyzerPerformance.frequencies().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (analysisCount == 0) {
                return BigDecimal.ZERO.setScale(2);
            }
            return BigDecimal.valueOf(100L).multiply(BigDecimal.valueOf(((Integer)e.getValue()).intValue())).divide(BigDecimal.valueOf(analysisCount), 2, RoundingMode.HALF_EVEN);
        }, TelemetryUtils.throwingMerger(), LinkedHashMap::new));
        return new TelemetryAnalyzerPerformancePayload(language, distribution);
    }

    static TelemetryNotificationsPayload toPayload(boolean devNotificationsDisabled, Map<String, TelemetryNotificationsCounter> notifications) {
        return new TelemetryNotificationsPayload(devNotificationsDisabled, TelemetryUtils.toNotifPayload(notifications));
    }

    private static Map<String, TelemetryNotificationsCounterPayload> toNotifPayload(Map<String, TelemetryNotificationsCounter> notifications) {
        return notifications.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new TelemetryNotificationsCounterPayload(((TelemetryNotificationsCounter)e.getValue()).getDevNotificationsCount(), ((TelemetryNotificationsCounter)e.getValue()).getDevNotificationsClicked())));
    }

    static boolean dayChanged(@Nullable LocalDateTime dateTime, long hours) {
        return dateTime == null || !LocalDate.now().equals(dateTime.toLocalDate()) && dateTime.until(LocalDateTime.now(), ChronoUnit.HOURS) >= hours;
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

