/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.shaded.org.springframework.context.expression;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.BeansException;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.BeanExpressionException;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.config.BeanExpressionContext;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.config.BeanExpressionResolver;
import org.sonarsource.sonarlint.shaded.org.springframework.context.expression.BeanExpressionContextAccessor;
import org.sonarsource.sonarlint.shaded.org.springframework.context.expression.BeanFactoryAccessor;
import org.sonarsource.sonarlint.shaded.org.springframework.context.expression.BeanFactoryResolver;
import org.sonarsource.sonarlint.shaded.org.springframework.context.expression.EnvironmentAccessor;
import org.sonarsource.sonarlint.shaded.org.springframework.context.expression.MapAccessor;
import org.sonarsource.sonarlint.shaded.org.springframework.core.convert.ConversionService;
import org.sonarsource.sonarlint.shaded.org.springframework.core.convert.support.DefaultConversionService;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.Expression;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.ExpressionParser;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.ParserContext;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.spel.SpelParserConfiguration;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.spel.standard.SpelExpressionParser;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.spel.support.StandardEvaluationContext;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.spel.support.StandardTypeConverter;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.spel.support.StandardTypeLocator;
import org.sonarsource.sonarlint.shaded.org.springframework.lang.Nullable;
import org.sonarsource.sonarlint.shaded.org.springframework.util.Assert;
import org.sonarsource.sonarlint.shaded.org.springframework.util.StringUtils;

public class StandardBeanExpressionResolver
implements BeanExpressionResolver {
    public static final String DEFAULT_EXPRESSION_PREFIX = "#{";
    public static final String DEFAULT_EXPRESSION_SUFFIX = "}";
    private String expressionPrefix = "#{";
    private String expressionSuffix = "}";
    private ExpressionParser expressionParser;
    private final Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>(256);
    private final Map<BeanExpressionContext, StandardEvaluationContext> evaluationCache = new ConcurrentHashMap<BeanExpressionContext, StandardEvaluationContext>(8);
    private final ParserContext beanExpressionParserContext = new ParserContext(){

        @Override
        public boolean isTemplate() {
            return true;
        }

        @Override
        public String getExpressionPrefix() {
            return StandardBeanExpressionResolver.this.expressionPrefix;
        }

        @Override
        public String getExpressionSuffix() {
            return StandardBeanExpressionResolver.this.expressionSuffix;
        }
    };

    public StandardBeanExpressionResolver() {
        this.expressionParser = new SpelExpressionParser();
    }

    public StandardBeanExpressionResolver(@Nullable ClassLoader beanClassLoader) {
        this.expressionParser = new SpelExpressionParser(new SpelParserConfiguration(null, beanClassLoader));
    }

    public void setExpressionPrefix(String expressionPrefix) {
        Assert.hasText(expressionPrefix, "Expression prefix must not be empty");
        this.expressionPrefix = expressionPrefix;
    }

    public void setExpressionSuffix(String expressionSuffix) {
        Assert.hasText(expressionSuffix, "Expression suffix must not be empty");
        this.expressionSuffix = expressionSuffix;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, "ExpressionParser must not be null");
        this.expressionParser = expressionParser;
    }

    @Override
    @Nullable
    public Object evaluate(@Nullable String value, BeanExpressionContext beanExpressionContext) throws BeansException {
        if (!StringUtils.hasLength(value)) {
            return value;
        }
        try {
            StandardEvaluationContext sec;
            Expression expr = this.expressionCache.get(value);
            if (expr == null) {
                expr = this.expressionParser.parseExpression(value, this.beanExpressionParserContext);
                this.expressionCache.put(value, expr);
            }
            if ((sec = this.evaluationCache.get(beanExpressionContext)) == null) {
                sec = new StandardEvaluationContext(beanExpressionContext);
                sec.addPropertyAccessor(new BeanExpressionContextAccessor());
                sec.addPropertyAccessor(new BeanFactoryAccessor());
                sec.addPropertyAccessor(new MapAccessor());
                sec.addPropertyAccessor(new EnvironmentAccessor());
                sec.setBeanResolver(new BeanFactoryResolver(beanExpressionContext.getBeanFactory()));
                sec.setTypeLocator(new StandardTypeLocator(beanExpressionContext.getBeanFactory().getBeanClassLoader()));
                sec.setTypeConverter(new StandardTypeConverter(() -> {
                    ConversionService cs = beanExpressionContext.getBeanFactory().getConversionService();
                    return cs != null ? cs : DefaultConversionService.getSharedInstance();
                }));
                this.customizeEvaluationContext(sec);
                this.evaluationCache.put(beanExpressionContext, sec);
            }
            return expr.getValue(sec);
        }
        catch (Throwable ex) {
            throw new BeanExpressionException("Expression parsing failed", ex);
        }
    }

    protected void customizeEvaluationContext(StandardEvaluationContext evalContext) {
    }
}

