/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.base;

import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.ISsoAuthenticatorOption;
import com.teamscale.core.authenticate.OAuthStateUtils;
import com.teamscale.core.authenticate.SSORequestCookieHandler;
import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.index.OAuthStateIndex;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.AdminContactUrlOption;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.ui.base.LoginContext;
import com.teamscale.ui.resources.CustomCssService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/context/login")
public class LoginContextService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Provides context for the login screen")
    @ApiResponse(responseCode="200", description="Login context retrieved successfully", content={@Content(schema=@Schema(implementation=LoginContext.class))})
    @RequiresNoLogin
    public Response getLoginContext(@QueryParam(value="redirection-target") @Parameter(description="A URL encoded redirection target that is used to build the redirection link for SSO providers.") @Nullable String redirectionTarget) throws StorageException, IOException {
        String sessionId = OAuthStateUtils.generateOAuthRequestId();
        LoginContext loginContext = new LoginContext(this.getAdminContact(), this.getExternalLogins(redirectionTarget, sessionId), CustomCssService.getCustomCssUrl());
        NewCookie samlCookie = SSORequestCookieHandler.createNewSSOCookie((URI)this.serviceInfo.getRequestBaseUri(), (String)sessionId);
        return Response.ok((Object)loginContext).cookie(new NewCookie[]{samlCookie}).build();
    }

    private String getAdminContact() throws StorageException {
        return StringUtils.emptyIfNull((String)AdminContactUrlOption.getAdministratorContactInformation((GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem()));
    }

    private List<LoginContext.ExternalLogin> getExternalLogins(@Nullable String redirectionTarget, String sessionToken) {
        ArrayList<LoginContext.ExternalLogin> externalLogins = new ArrayList<LoginContext.ExternalLogin>();
        URI baseUri = this.serviceInfo.getRequestBaseUri();
        try {
            ServerOptionIndex optionIndex = (ServerOptionIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
            OAuthStateIndex oAuthStateIndex = (OAuthStateIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(OAuthStateIndex.class);
            externalLogins.addAll(LoginContextService.getSsoLogins(optionIndex, oAuthStateIndex, ESsoAuthenticatorType.SAML, baseUri, redirectionTarget, sessionToken));
            externalLogins.addAll(LoginContextService.getSsoLogins(optionIndex, oAuthStateIndex, ESsoAuthenticatorType.OPENID_CONNECT, baseUri, redirectionTarget, sessionToken));
            externalLogins.addAll(LoginContextService.getGitHubLogins(optionIndex, oAuthStateIndex, baseUri, redirectionTarget, sessionToken));
        }
        catch (StorageException e) {
            LOGGER.warn("Storage issues while displaying login page: {}", (Object)e.getMessage(), (Object)e);
        }
        return externalLogins;
    }

    private static List<LoginContext.ExternalLogin> getGitHubLogins(ServerOptionIndex optionIndex, OAuthStateIndex oAuthStateIndex, URI baseUri, String redirectionTarget, String sessionToken) throws StorageException {
        List availableApplicationDescriptions = GitHubAppUtils.loadAllConfiguredApplications((ServerOptionIndex)optionIndex);
        ArrayList<LoginContext.ExternalLogin> logins = new ArrayList<LoginContext.ExternalLogin>();
        for (GitHubApplicationDescription applicationDescription : availableApplicationDescriptions) {
            if (!applicationDescription.useForSso) continue;
            applicationDescription.buildRedirectionLink(baseUri, redirectionTarget, sessionToken, oAuthStateIndex).ifPresent(url -> logins.add(new LoginContext.ExternalLogin(applicationDescription.getDisplayName(), (String)url, applicationDescription.getAuthenticatorType())));
        }
        return logins;
    }

    private static List<LoginContext.ExternalLogin> getSsoLogins(ServerOptionIndex optionIndex, OAuthStateIndex oAuthStateIndex, ESsoAuthenticatorType authenticatorOptionType, URI baseUri, @Nullable String redirectionTarget, String sessionToken) throws StorageException {
        Map options = ServerOptionRegistry.getServerMultiOptionAll((String)authenticatorOptionType.getOptionId(), (ServerOptionIndex)optionIndex);
        ArrayList<LoginContext.ExternalLogin> logins = new ArrayList<LoginContext.ExternalLogin>();
        for (IOption value : options.values()) {
            ISsoAuthenticatorOption authenticatorOption = (ISsoAuthenticatorOption)CCSMAssert.checkedCast((Object)value, ISsoAuthenticatorOption.class);
            authenticatorOption.buildRedirectionLink(baseUri, redirectionTarget, sessionToken, oAuthStateIndex).ifPresent(url -> logins.add(new LoginContext.ExternalLogin(authenticatorOption.getDisplayName(), (String)url, authenticatorOption.getAuthenticatorType())));
        }
        return logins;
    }
}

