/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.MatlabVariable;
import org.conqat.lib.simulink.builder.SimulinkNumericType;
import org.conqat.lib.simulink.builder.SimulinkParameter;

@IndexValueClass
public abstract class SimulinkDataStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, ISimulinkDataDictionaryEntry> entries;

    protected SimulinkDataStorage() {
        this.entries = Collections.emptyMap();
    }

    protected SimulinkDataStorage(Set<ISimulinkDataDictionaryEntry> entries) {
        Map map = entries.stream().collect(Collectors.toMap(ISimulinkDataDictionaryEntry::getName, Function.identity()));
        this.entries = Collections.unmodifiableMap(map);
    }

    public Collection<ISimulinkDataDictionaryEntry> getEntries() {
        return this.entries.values();
    }

    public Optional<ISimulinkDataDictionaryEntry> findEntry(String name) {
        return Optional.ofNullable(this.entries.get(name));
    }

    public Set<String> getEntryNames() {
        return this.entries.keySet();
    }

    public Optional<MatlabVariable> findMatlabVariable(String variableName) {
        return this.findEntry(variableName, MatlabVariable.class);
    }

    public Optional<SimulinkNumericType> findNumericType(String typeName) {
        return this.findEntry(typeName, SimulinkNumericType.class);
    }

    public Optional<SimulinkParameter> findParameter(String parameterName) {
        return this.findEntry(parameterName, SimulinkParameter.class);
    }

    private <T extends ISimulinkDataDictionaryEntry> Optional<T> findEntry(String variableName, Class<T> type) {
        ISimulinkDataDictionaryEntry entry = this.entries.get(variableName);
        if (type.isInstance(entry)) {
            return Optional.of((ISimulinkDataDictionaryEntry)type.cast(entry));
        }
        return Optional.empty();
    }
}

