/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.conqat.lib.simulink.builder.MDLParser;
import org.conqat.lib.simulink.builder.MDLScanner;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.ModelDictionaryHandler;
import org.conqat.lib.simulink.builder.MutableMDLSection;
import org.conqat.lib.simulink.builder.SLXModelHandler;
import org.conqat.lib.simulink.builder.SLXModelSanitizer;
import org.conqat.lib.simulink.builder.SLXStateflowHandler;
import org.conqat.lib.simulink.builder.SimulinkBuilder;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.builder.SimulinkModelDataExtractor;
import org.conqat.lib.simulink.builder.SimulinkModelWorkspace;
import org.conqat.lib.simulink.builder.SimulinkModelWorkspaceParser;
import org.conqat.lib.simulink.builder.StateflowBuilder;
import org.conqat.lib.simulink.builder.file.ISimulinkFileContentProvider;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandlerFactory;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.jspecify.annotations.NonNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimulinkModelBuilder
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CONTROL_CHARACTERS_REGEX = "[\\x00-\\x1F]";
    private static final String SLX_MODEL_DICTIONARY_FILE = "simulink/modelDictionary.xml";
    private static final String SLX_DEFAULTS_FILE = "simulink/bddefaults.xml";
    private static final String SLX_STATEFLOW_FILE = "simulink/stateflow.xml";
    private static final Pattern SLX_CONFIG_SET_FILE_PATTERN = Pattern.compile("simulink/configSet[0-9]+\\.xml");
    private static final String SLX_CONFIG_SET_INFO = "simulink/configSetInfo.xml";
    private static final String SLX_STATEFLOW_2020_FILE = "simulink/stateflow/machine.xml";
    private static final String WINDOWS_INFO_FILE = "simulink/windowsInfo.xml";
    private static final String SLX_MXDATA_FOLDER = "simulink/bdmxdata/";
    private static final String SLX_SYSTEMS_FOLDER = "simulink/systems/";
    private static final String SLX_STATEFLOW_FOLDER = "simulink/stateflow/";
    private static final String SLX_PROPERTIES_FILE = "metadata/mwcoreProperties.xml";
    public static final String SLX_FILE_EXTENSION = ".slx";
    public static final String MDL_FILE_EXTENSION = ".mdl";
    private static final String MISSING_MODEL_BLOCK_EXCEPTION = "Model must have exactly one Model or Library block.";
    public static final String MX_ARRAY_SEPARATOR = "@";
    private static final Pattern MODEL_DATA_BLOCK_PATTERN = Pattern.compile("(?s)<P\\s+Name=\"ModelData\"[^>]*>[\\s\\S]*?</P>");
    private static final Set<String> IGNORED_OBJECT_PARAMETER_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"ClassName", "PropName"});
    private static final Set<String> WHITELISTED_OBJECT_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"BdWindowsInfo", "WindowsInfo", "ModelBrowserInfo"});
    private final byte[] fileContent;
    private final List<InputStream> streamsToClose = new ArrayList<InputStream>();
    private ISimulinkFileContentProvider fileContentProvider;
    private final Map<String, String> configInputContents = new HashMap<String, String>();
    private final PairList<String, String> modelMxData = new PairList();
    private boolean isSlxFormat;
    private final String originId;
    private final String filename;
    private final Function<String, SimulinkModel> modelResolver;
    private String uniformPath;
    private SimulinkModelWorkspace modelWorkspace = SimulinkModelWorkspace.EMPTY_MODEL_WORKSPACE;

    public SimulinkModelBuilder(InputStream inputStream, Function<String, SimulinkModel> modelResolver, String filename, String originId) throws IOException {
        this(FileSystemUtils.readStreamBinary((InputStream)inputStream), modelResolver, filename, originId);
        this.streamsToClose.add(inputStream);
    }

    public SimulinkModelBuilder(InputStream inputStream, String filename, String originId) throws IOException {
        this(FileSystemUtils.readStreamBinary((InputStream)inputStream), (String x) -> null, filename, originId);
        this.streamsToClose.add(inputStream);
    }

    public SimulinkModelBuilder(File file, Function<String, SimulinkModel> modelResolver, String originId) throws IOException {
        this(FileSystemUtils.readFileBinary((File)file), modelResolver, file.getName(), originId);
    }

    public SimulinkModelBuilder(File tempFile, String filename, String originId) throws IOException {
        this(FileSystemUtils.readFileBinary((File)tempFile), (String x) -> null, filename, originId);
    }

    public SimulinkModelBuilder(File file, Function<String, SimulinkModel> modelResolver) throws IOException {
        this(file, modelResolver, FileSystemUtils.getFilenameWithoutExtension((File)file));
    }

    public SimulinkModelBuilder(File file) throws IOException {
        this(file, (String x) -> null, FileSystemUtils.getFilenameWithoutExtension((File)file));
    }

    public SimulinkModelBuilder(byte[] content, Function<String, SimulinkModel> modelResolver, String uniformPath) throws IOException {
        this(content, modelResolver, uniformPath, null);
        this.setUniformPath(uniformPath);
    }

    private SimulinkModelBuilder(byte[] content, Function<String, SimulinkModel> modelResolver, String filename, String originId) {
        this.fileContent = content;
        this.originId = originId;
        this.filename = filename;
        this.modelResolver = modelResolver;
    }

    private void fetchAllConfigSetXmlFiles() {
        for (String configSetName : this.getConfigSetFileNames()) {
            Optional<String> content = this.fileContentProvider.getNamedContent(configSetName);
            content.ifPresent(s -> this.configInputContents.put("/" + configSetName, (String)s));
        }
    }

    private MDLSection getStateFlowMachine(String content) throws SimulinkModelBuildingException {
        try {
            SLXStateflowHandler handler = new SLXStateflowHandler();
            XMLUtils.parseSAX((String)content, (DefaultHandler)handler);
            MutableMDLSection slxFile = handler.getRootMachineSection();
            SLXModelSanitizer.sanitize(slxFile, this.filename);
            return slxFile.asImmutable();
        }
        catch (IOException | SAXException e) {
            throw new SimulinkModelBuildingException(e);
        }
    }

    private List<String> getConfigSetFileNames() {
        return this.fileContentProvider.listContainedFilenames(name -> SLX_CONFIG_SET_FILE_PATTERN.matcher((CharSequence)name).matches());
    }

    private void extractMxDataForModel() {
        for (String name2 : this.fileContentProvider.listContainedFilenames(name -> name.startsWith(SLX_MXDATA_FOLDER))) {
            String processedMxArrayFileContent;
            Optional<String> mxArrayFileContent = this.fileContentProvider.getNamedContent(name2);
            if (!mxArrayFileContent.isPresent() || (processedMxArrayFileContent = SimulinkModelBuilder.processMxArrayFileContent(mxArrayFileContent.get())) == null) continue;
            this.modelMxData.add((Object)SimulinkModelBuilder.createVariantControlsKeyFromMxData(name2), (Object)processedMxArrayFileContent);
        }
    }

    private static String processMxArrayFileContent(String data) {
        String processedData = Arrays.stream(data.split(CONTROL_CHARACTERS_REGEX)).filter(part -> part.length() > 1).collect(Collectors.joining(MX_ARRAY_SEPARATOR));
        int index = processedData.indexOf(MX_ARRAY_SEPARATOR);
        if (index < 0) {
            return null;
        }
        return processedData.substring(index + 1);
    }

    private static String createVariantControlsKeyFromMxData(String mxDataFileName) {
        mxDataFileName = StringUtils.removeAll((String)mxDataFileName, (String[])new String[]{".mxarray", SLX_MXDATA_FOLDER});
        return "bdmxdata:" + mxDataFileName;
    }

    static void moveStreamToEntry(String entryName, ZipArchiveInputStream zipInputStream) throws IOException {
        ZipArchiveEntry entry = zipInputStream.getNextZipEntry();
        while (entry != null) {
            if (entryName.equals(entry.getName())) {
                return;
            }
            entry = zipInputStream.getNextZipEntry();
        }
        throw new IOException("No entry named " + entryName + " found.");
    }

    public SimulinkModel buildModel() throws SimulinkModelBuildingException {
        return this.buildModel(new ModelBuildingParameters());
    }

    public SimulinkModel buildModel(ModelBuildingParameters parameters) throws SimulinkModelBuildingException {
        this.fileContentProvider = ISimulinkFileContentProvider.buildInstance(this.filename, this.fileContent, parameters);
        this.isSlxFormat = this.fileContentProvider.isMultiFileContainer();
        MDLSection simulinkFile = this.parseFile();
        MDLSection modelSection = SimulinkModelBuilder.getSimulinkModelSection(simulinkFile);
        if (this.isSlxFormat && ModelDataHandlerFactory.getMatlabReleaseVersionYear(modelSection.getMatlabReleaseVersionName()) < 2025) {
            this.modelWorkspace = SimulinkModelWorkspaceParser.parseModelWorkspace(this.fileContentProvider, this.uniformPath);
        }
        ModelDataHandler modelDataHandler = ModelDataHandlerFactory.createModelHandler(modelSection.getParameter("Version"), modelSection.getMatlabReleaseVersionName(), this.isSlxFormat, parameters);
        SimulinkModel model = new SimulinkModel(modelSection.getName().equals("Library"), modelSection.getName().equals("Subsystem"), this.originId, modelDataHandler, this.uniformPath, this.modelResolver, this.modelWorkspace);
        SimulinkModelBuilder.addParameters(model, modelSection);
        this.saveMxDataAsParameters(model);
        this.buildStateFlowMachine(simulinkFile, model, modelDataHandler, parameters);
        new SimulinkBuilder(model, parameters, this.isSlxFormat).buildSimulink(modelSection);
        new SimulinkModelDataExtractor(this.isSlxFormat, this.fileContentProvider).addDataToModel(simulinkFile, model);
        if (model.getStateflowMachine() != null) {
            for (StateflowChart chart : model.getStateflowMachine().getCharts(true)) {
                chart.completeChartSetup();
            }
        }
        return model;
    }

    private void saveMxDataAsParameters(SimulinkModel model) {
        for (int i = 0; i < this.modelMxData.size(); ++i) {
            model.setParameter((String)this.modelMxData.getFirst(i), (String)this.modelMxData.getSecond(i));
        }
    }

    private void buildStateFlowMachine(MDLSection simulinkFile, SimulinkModel model, ModelDataHandler modelDataHandler, ModelBuildingParameters parameters) throws SimulinkModelBuildingException {
        MDLSection stateflowSection = this.extractStateflowSection(simulinkFile);
        if (stateflowSection != null) {
            new StateflowBuilder(parameters, model).buildStateflow(stateflowSection, modelDataHandler);
        }
    }

    private MDLSection extractStateflowSection(MDLSection simulinkFile) throws SimulinkModelBuildingException {
        try {
            Optional<String> stateflowContent = this.fileContentProvider.getNamedContent(SLX_STATEFLOW_FILE);
            if (stateflowContent.isPresent()) {
                return this.getStateFlowMachine(stateflowContent.get());
            }
            stateflowContent = this.fileContentProvider.getNamedContent(SLX_STATEFLOW_2020_FILE);
            if (stateflowContent.isPresent()) {
                return this.getStateFlowMachine(this.buildVersion2020StateflowContent(stateflowContent.get()));
            }
            return simulinkFile.getFirstSubSection("Stateflow");
        }
        catch (IOException | TransformerException | SAXException e) {
            throw new SimulinkModelBuildingException(e);
        }
    }

    private String buildVersion2020StateflowContent(String stateflowContent) throws SAXException, IOException, TransformerException {
        Map<String, String> systemNameToFullName = this.createSystemNameMappingForFolder(SLX_STATEFLOW_FOLDER);
        Document stateflowMachine = XMLUtils.parse((InputSource)new InputSource(new StringReader(stateflowContent)));
        NodeList chartReferences = stateflowMachine.getDocumentElement().getElementsByTagName("chart");
        for (Element chartReference : XMLUtils.elementNodes((NodeList)chartReferences)) {
            Optional<String> referenceContent;
            String reference = chartReference.getAttributes().getNamedItem("Ref").getNodeValue();
            if (!systemNameToFullName.containsKey(reference) || !(referenceContent = this.fileContentProvider.getNamedContent(systemNameToFullName.get(reference))).isPresent()) continue;
            Document referencedChart = XMLUtils.parse((InputSource)new InputSource(new StringReader(referenceContent.get())));
            Node importedChartNode = stateflowMachine.importNode(referencedChart.getDocumentElement(), true);
            chartReference.getParentNode().replaceChild(importedChartNode, chartReference);
        }
        return XMLUtils.print((Document)stateflowMachine);
    }

    private @NonNull Map<String, String> createSystemNameMappingForFolder(String folder) {
        HashMap<String, String> systemNameToFullName = new HashMap<String, String>();
        this.fileContentProvider.listContainedFilenames(name -> name.startsWith(folder) && !name.contains("/_rels/")).forEach(name -> {
            String systemFileName = StringUtils.getLastPart((String)name, (String)"/");
            systemFileName = StringUtils.removeLastPart((String)systemFileName, (char)'.');
            systemNameToFullName.put(systemFileName, (String)name);
        });
        return systemNameToFullName;
    }

    private static MDLSection getSimulinkModelSection(MDLSection simulinkFile) throws SimulinkModelBuildingException {
        UnmodifiableList<MDLSection> namedBlocks = simulinkFile.getSubSections("Model");
        if (namedBlocks.isEmpty()) {
            namedBlocks = simulinkFile.getSubSections("Library");
        }
        if (namedBlocks.isEmpty()) {
            namedBlocks = simulinkFile.getSubSections("Subsystem");
        }
        if (namedBlocks.size() != 1) {
            throw new SimulinkModelBuildingException(MISSING_MODEL_BLOCK_EXCEPTION);
        }
        return (MDLSection)namedBlocks.get(0);
    }

    private MDLSection parseFile() throws SimulinkModelBuildingException {
        try {
            if (this.isSlxFormat) {
                this.fetchAllConfigSetXmlFiles();
                this.extractMxDataForModel();
                SLXModelHandler handler = new SLXModelHandler();
                String fileContent = this.fileContentProvider.getMainContent().trim();
                XMLUtils.parseSAX((InputSource)new InputSource(new StringReader(this.removeBOMCharacter(fileContent))), (DefaultHandler)handler);
                MutableMDLSection slxFile = handler.getRootModelSection();
                this.addExternalDataToModelSection(slxFile);
                SLXModelSanitizer.sanitize(slxFile, this.filename);
                return slxFile.asImmutable();
            }
            MDLScanner scanner = new MDLScanner(new StringReader(this.fileContentProvider.getMainContent()));
            MDLParser parser = new MDLParser(scanner);
            return (MDLSection)parser.parse().value;
        }
        catch (Exception e) {
            throw new SimulinkModelBuildingException(e);
        }
    }

    private String removeBOMCharacter(String content) {
        if (!content.isEmpty() && content.charAt(0) == '\ufeff') {
            return content.substring(1);
        }
        return content;
    }

    private void addExternalDataToModelSection(MutableMDLSection slxFile) throws IOException, SAXException, SimulinkModelBuildingException {
        this.parseXmlContentAndUpdateModel(SLX_DEFAULTS_FILE, "BlockDiagramDefaults", slxFile);
        this.parseXmlContentAndUpdateModel(SLX_PROPERTIES_FILE, "mwcoreProperties", slxFile);
        this.parseXmlContentAndUpdateModel(WINDOWS_INFO_FILE, "WindowsInfo", slxFile);
        if (!this.configInputContents.isEmpty()) {
            this.parseConfigSetXmlFileAndUpdateModel(slxFile);
        }
        this.parseModelDictionaryAndUpdateModel(slxFile);
        this.addSystemDataToModel(slxFile);
    }

    private void addSystemDataToModel(MutableMDLSection slxFile) throws IOException, SAXException {
        MutableMDLSection model = slxFile.getFirstSubSection("Model");
        if (model == null) {
            model = slxFile.getFirstSubSection("Library");
        }
        if (model == null) {
            model = slxFile.getFirstSubSection("Subsystem");
        }
        if (model == null) {
            return;
        }
        this.parseSystemXmlFilesAndUpdateModel((List)model.getSubSections().getValues(), this.createSystemNameMappingForFolder(SLX_SYSTEMS_FOLDER));
    }

    private void parseSystemXmlFilesAndUpdateModel(List<MutableMDLSection> modelSubsections, Map<String, String> systemNameToFullName) throws IOException, SAXException {
        if (CollectionUtils.isNullOrEmpty(modelSubsections)) {
            return;
        }
        for (MutableMDLSection modelSection : modelSubsections) {
            Optional<String> optionalContent;
            String systemName = modelSection.getParameter("Ref");
            if (systemName != null && systemNameToFullName.containsKey(systemName) && (optionalContent = this.fileContentProvider.getNamedContent(systemNameToFullName.remove(systemName))).isPresent()) {
                String content = this.removeModelDataBlock(optionalContent.get(), systemName);
                SLXModelHandler systemHandler = new SLXModelHandler("System");
                XMLUtils.parseSAX((InputSource)new InputSource(new StringReader(content)), (DefaultHandler)systemHandler);
                MutableMDLSection systemSection = systemHandler.getRootModelSection();
                modelSection.addSubSections((List)systemSection.getSubSections().getValues());
                systemSection.getParameters().forEach(modelSection::setParameter);
            }
            this.parseSystemXmlFilesAndUpdateModel((List)modelSection.getSubSections().getValues(), systemNameToFullName);
        }
    }

    private void parseXmlContentAndUpdateModel(String contentName, String rootSectionName, MutableMDLSection slxFile) throws IOException, SAXException, SimulinkModelBuildingException {
        Optional<String> content = this.fileContentProvider.getNamedContent(contentName);
        if (!content.isPresent()) {
            return;
        }
        SLXModelHandler handler = new SLXModelHandler(rootSectionName);
        XMLUtils.parseSAX((InputSource)new InputSource(new StringReader(content.get())), (DefaultHandler)handler);
        SimulinkModelBuilder.addSettingsToSlxModel(slxFile, (List)handler.getRootModelSection().getSubSections().getValues());
    }

    private static String getActiveConfigName(String configSetInfoContent) throws IOException, SAXException {
        SLXModelHandler handler = new SLXModelHandler("ConfigSetInfo");
        XMLUtils.parseSAX((InputSource)new InputSource(new StringReader(configSetInfoContent)), (DefaultHandler)handler);
        for (MutableMDLSection config : handler.getRootModelSection().getSubSections("ConfigSet")) {
            if (!"true".equals(config.getParameter("Active"))) continue;
            return config.getParameter("PartName");
        }
        return null;
    }

    private void parseConfigSetXmlFileAndUpdateModel(MutableMDLSection slxFile) throws IOException, SAXException, SimulinkModelBuildingException {
        String configName;
        Optional<String> configSetInfo = this.fileContentProvider.getNamedContent(SLX_CONFIG_SET_INFO);
        if (configSetInfo.isPresent()) {
            configName = SimulinkModelBuilder.getActiveConfigName(configSetInfo.get());
        } else if (this.configInputContents.size() == 1) {
            configName = (String)CollectionUtils.getAny(this.configInputContents.keySet());
        } else {
            throw new SimulinkModelBuildingException(String.format("Multiple configSet[0-9]+.xml files given but no %s found which defines the active configuration", SLX_CONFIG_SET_INFO));
        }
        String config = this.configInputContents.get(configName);
        if (config == null) {
            throw new SimulinkModelBuildingException(String.format("Active config with the name %s found in %s, but not found as a file", configName, SLX_CONFIG_SET_INFO));
        }
        SLXModelHandler handler = new SLXModelHandler("ConfigSet");
        XMLUtils.parseSAX((InputSource)new InputSource(new StringReader(config)), (DefaultHandler)handler);
        SimulinkModelBuilder.addSettingsToSlxModel(slxFile, Collections.singletonList(handler.getRootModelSection()));
    }

    private static void addSettingsToSlxModel(MutableMDLSection slxFile, List<MutableMDLSection> sectionsFromHandler) throws SimulinkModelBuildingException {
        MutableMDLSection model = slxFile.getFirstSubSection("Model");
        if (model == null) {
            model = slxFile.getFirstSubSection("Library");
        }
        if (model == null) {
            model = slxFile.getFirstSubSection("Subsystem");
        }
        if (model == null) {
            throw new SimulinkModelBuildingException(MISSING_MODEL_BLOCK_EXCEPTION);
        }
        model.addSubSections(sectionsFromHandler);
    }

    private void parseModelDictionaryAndUpdateModel(MutableMDLSection slxFile) throws IOException, SAXException {
        Optional<String> content = this.fileContentProvider.getNamedContent(SLX_MODEL_DICTIONARY_FILE);
        if (content.isPresent()) {
            ModelDictionaryHandler handler = new ModelDictionaryHandler();
            XMLUtils.parseSAX((InputSource)new InputSource(new StringReader(content.get())), (DefaultHandler)handler);
            SimulinkModelBuilder.addModelDictionaryToSlxModel(handler, slxFile);
        }
    }

    private static void addModelDictionaryToSlxModel(ModelDictionaryHandler handler, MutableMDLSection slxFile) {
        MutableMDLSection model = slxFile.getFirstSubSection("Model");
        if (model == null) {
            return;
        }
        model.addSubSection(handler.getRootModelSection());
    }

    @Override
    public void close() {
        this.streamsToClose.forEach(FileSystemUtils::close);
    }

    static void addParameters(ParameterizedElement element, MDLSection section) {
        for (String name : section.getParameterNames()) {
            if ("Points".equals(name)) {
                Object value = element.getParameter("Points");
                String newValue = section.getParameter("Points");
                if (value == null) {
                    value = newValue;
                } else if (newValue != null) {
                    value = newValue.substring(0, newValue.length() - 1) + "; " + ((String)value).substring(1);
                }
                element.setParameter("Points", (String)value);
                continue;
            }
            if ("Teamscale_XML_Text_Content".equals(name)) continue;
            element.setParameter(name, section.getParameter(name));
        }
        SimulinkModelBuilder.addParametersFromObjectSections(element, section);
    }

    private static void addParametersFromObjectSections(ParameterizedElement element, MDLSection section) {
        for (MDLSection objectSection : section.getSubSections("Object")) {
            String objectName = objectSection.getParameter("PropName");
            if (objectName == null || !WHITELISTED_OBJECT_NAMES.contains(objectName)) continue;
            for (String subParameter : objectSection.getParameterNames()) {
                if (IGNORED_OBJECT_PARAMETER_NAMES.contains(subParameter)) continue;
                element.setParameter(objectName + "." + subParameter, objectSection.getParameter(subParameter));
            }
            SimulinkModelBuilder.addParametersFromObjectSections(element, objectSection);
        }
    }

    private String removeModelDataBlock(String content, String xmlFilename) {
        Matcher matcher = MODEL_DATA_BLOCK_PATTERN.matcher(content);
        if (matcher.find()) {
            LOGGER.info("Removing ModelData block from model: {} in file {}", (Object)this.filename, (Object)xmlFilename);
            return matcher.replaceAll("");
        }
        return content;
    }

    public void setUniformPath(String uniformPath) {
        this.uniformPath = uniformPath;
    }
}

