/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowEvent;
import org.conqat.lib.simulink.model.stateflow.StateflowResolvedIdUtils;

public abstract class StateflowDeclContainerBase<P extends IStateflowElement<?>>
extends StateflowElementBase<P> {
    private final IdentityHashSet<StateflowData> dates = new IdentityHashSet();
    private final IdentityHashSet<StateflowEvent> events = new IdentityHashSet();

    StateflowDeclContainerBase() {
    }

    public void addData(StateflowData data) {
        this.dates.add((Object)data);
        data.setParent(this);
    }

    public void addEvent(StateflowEvent event) {
        this.events.add((Object)event);
        event.setParent(this);
    }

    public UnmodifiableSet<StateflowData> getData() {
        return CollectionUtils.asUnmodifiable(this.dates);
    }

    public UnmodifiableSet<StateflowEvent> getEvents() {
        return CollectionUtils.asUnmodifiable(this.events);
    }

    void removeData(StateflowData data) {
        CCSMAssert.isTrue((data.getParent() == this ? 1 : 0) != 0, (String)"Data object must belong to container to be removed.");
        this.dates.remove((Object)data);
        data.setParent(null);
    }

    void removeEvent(StateflowEvent event) {
        CCSMAssert.isTrue((event.getParent() == this ? 1 : 0) != 0, (String)"Event must belong to container to be removed.");
        this.events.remove((Object)event);
        event.setParent(null);
    }

    @Deprecated
    public List<String> getSplitResolvedIdWithResolvedLabels() {
        return StateflowResolvedIdUtils.getSplitResolvedIdWithResolvedLabels(this);
    }

    @Deprecated
    public String getResolvedIdWithResolvedLabels() {
        return StateflowResolvedIdUtils.getResolvedIdWithResolvedLabels(this);
    }
}

