/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.targetlink;

import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

class TargetlinkStruct {
    private final HashMap<String, TargetlinkStruct> children = new HashMap();
    private final HashMap<String, String> parameters = new HashMap();

    TargetlinkStruct() {
    }

    public void addChild(String name, TargetlinkStruct struct) {
        this.children.put(name, struct);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.addParameters(result, "");
        return result;
    }

    private void addParameters(Map<String, String> map, String prefix) {
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            map.put(prefix + "/" + entry.getKey(), entry.getValue());
        }
        this.children.forEach((childName, child) -> child.addParameters(map, prefix + "/" + childName));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("struct (");
        result.append(StringUtils.LINE_SEPARATOR);
        for (String childName : CollectionUtils.sort(this.children.keySet())) {
            result.append("  ");
            result.append("'");
            result.append(childName);
            result.append("' -> ");
            result.append(StringUtils.prefixLines((String)this.children.get(childName).toString(), (String)"  ", (boolean)false));
            result.append(StringUtils.LINE_SEPARATOR);
        }
        for (String paramName : CollectionUtils.sort(this.parameters.keySet())) {
            result.append("  ");
            result.append("'");
            result.append(paramName);
            result.append("' -> '");
            result.append(this.parameters.get(paramName));
            result.append("'");
            result.append(StringUtils.LINE_SEPARATOR);
        }
        result.append(")");
        return result.toString();
    }
}

