/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SimulinkQualifiedNameResolver {
    private static final Logger LOGGER = LogManager.getLogger();

    @VisibleForTesting
    public static ParameterizedElement findElementInModel(SimulinkModel model, String qualifiedName) {
        List<String> names = SimulinkUtils.splitSimulinkId(qualifiedName);
        if (StringUtils.isEmpty((String)qualifiedName) || names.isEmpty()) {
            return model;
        }
        if (!names.get(0).equalsIgnoreCase(model.getName())) {
            return null;
        }
        return SimulinkQualifiedNameResolver.findElementBelowSimulinkBlock(model, names.subList(1, names.size()));
    }

    private static ParameterizedElement findElementBelowSimulinkBlock(SimulinkBlock parent, List<String> names) {
        SimulinkBlock block = parent;
        for (int i = 0; i < names.size(); ++i) {
            if (block instanceof StateflowBlock) {
                List<String> remainingNames = names.subList(i, names.size());
                StateflowChart chart = ((StateflowBlock)block).getChart();
                ParameterizedElement elementInStateflow = SimulinkQualifiedNameResolver.findElementBelowChart(chart, remainingNames);
                if (elementInStateflow != null) {
                    return elementInStateflow;
                }
            }
            if ((block = block.getSubBlockWithWhitespaceNormalization(names.get(i))) != null) continue;
            LOGGER.error("Unknown model element: " + StringUtils.concat(names, (String)"/"));
            return null;
        }
        if (block instanceof StateflowBlock) {
            return ((StateflowBlock)block).getChart();
        }
        return block;
    }

    private static ParameterizedElement findElementBelowChart(StateflowChart chart, List<String> names) throws IllegalArgumentException {
        IStateflowNodeContainer<IStateflowChartContainer<?>> currentParent = chart;
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Optional<StateflowState> stateflowStateChild = SimulinkQualifiedNameResolver.findStateflowStateChild(currentParent, name);
            if (stateflowStateChild.isPresent()) {
                Optional<SimulinkBlock> linkedSimulinkBlock = SimulinkQualifiedNameResolver.findLinkedSimulinkBlock(stateflowStateChild.get(), chart);
                if (linkedSimulinkBlock.isPresent()) {
                    List<String> remainingNames = names.subList(i + 1, names.size());
                    return SimulinkQualifiedNameResolver.findElementBelowSimulinkBlock(linkedSimulinkBlock.get(), remainingNames);
                }
            } else {
                if (chart.getStateflowBlock() != null && chart.getStateflowBlock().getSubBlock(name) != null) {
                    List<String> remainingNames = names.subList(i + 1, names.size());
                    return SimulinkQualifiedNameResolver.findElementBelowSimulinkBlock(chart.getStateflowBlock().getSubBlock(name), remainingNames);
                }
                return null;
            }
            currentParent = stateflowStateChild.get();
            StateflowState currentParentState = (StateflowState)currentParent;
            if (!currentParentState.isSubChart()) continue;
            currentParent = currentParentState.getSubViewer();
        }
        if (currentParent instanceof ParameterizedElement) {
            return currentParent;
        }
        LOGGER.error("Could not convert " + currentParent.buildQualifiedName() + " to displayable information.");
        return null;
    }

    private static Optional<SimulinkBlock> findLinkedSimulinkBlock(StateflowState stateflowStateChild, StateflowChart chart) {
        String linkedSimulinkBlockName = stateflowStateChild.getParameter("simulink.blockName");
        if (linkedSimulinkBlockName != null && chart.getStateflowBlock() != null) {
            return Optional.ofNullable(chart.getStateflowBlock().getSubBlock(linkedSimulinkBlockName));
        }
        return Optional.empty();
    }

    private static Optional<StateflowState> findStateflowStateChild(IStateflowNodeContainer<?> parent, String stateQualifiedNamePart) {
        String[] nameComponents = stateQualifiedNamePart.split("\\.", -1);
        if (nameComponents.length == 0) {
            return Optional.empty();
        }
        StateflowState current = parent.findDirectChildStateByQualifiedNameComponent(nameComponents[0]);
        if (current == null) {
            return Optional.empty();
        }
        for (int i = 1; i < nameComponents.length; ++i) {
            String nodeName = nameComponents[i];
            if ((current = current.findDirectChildStateByQualifiedNameComponent(nodeName)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(current);
    }
}

