/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.handler;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.user.ProjectUserActivityIndex;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.service_log.ServiceLoadIndex;
import com.teamscale.index.usage_data.UserAgentsIndex;
import com.teamscale.service.framework.IServiceStatisticsRecorder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.string.StringUtils;

class ServiceStatisticsRecorder
implements IServiceStatisticsRecorder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AtomicInteger serviceCallCount = new AtomicInteger();
    private final Map<String, Long> userLastActiveTime = new HashMap<String, Long>();
    private final UserLastActivityIndex userLastActivityIndex;
    private final ProjectIndex projectIndex;
    private final ServiceLoadIndex serviceLoadIndex;
    private final UserAgentsIndex userAgentsIndex;
    private final Timer persisterTimer;
    private final ProjectUserActivityIndex projectUserActivityIndex;
    private final SetMap<PublicProjectId, String> userActivity = new SetMap();
    private final TwoDimHashMap<String, String, Long> userAgents = new TwoDimHashMap();

    ServiceStatisticsRecorder(ServiceLoadIndex serviceLoadIndex, UserLastActivityIndex userLastActivityIndex, ProjectUserActivityIndex projectUserActivityIndex, ProjectIndex projectIndex, UserAgentsIndex userAgentsIndex) {
        this.userLastActivityIndex = userLastActivityIndex;
        this.serviceLoadIndex = serviceLoadIndex;
        this.projectUserActivityIndex = projectUserActivityIndex;
        this.projectIndex = projectIndex;
        this.userAgentsIndex = userAgentsIndex;
        this.persisterTimer = new Timer(true);
        this.persisterTimer.scheduleAtFixedRate((TimerTask)new StatisticsPersisterTask(this), DurationUtils.ONE_MINUTE.toMillis(), DurationUtils.ONE_MINUTE.toMillis());
        this.persisterTimer.scheduleAtFixedRate((TimerTask)new StatisticsWiperTask(this), DurationUtils.ONE_MINUTE.toMillis(), DurationUtils.ONE_HOUR.toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserAccess(IProjectId projectId, String username) {
        long currentTimeMillis = System.currentTimeMillis();
        Map<String, Long> map = this.userLastActiveTime;
        synchronized (map) {
            this.userLastActiveTime.put(username, currentTimeMillis);
        }
        if (projectId == null) {
            return;
        }
        map = this.userActivity;
        synchronized (map) {
            if (!projectId.isInternal()) {
                this.userActivity.add((Object)((PublicProjectId)projectId), (Object)username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserAgent(String user, String userAgent) {
        CCSMAssert.isNotNull((Object)user);
        TwoDimHashMap<String, String, Long> twoDimHashMap = this.userAgents;
        synchronized (twoDimHashMap) {
            this.userAgents.putValue((Object)user, (Object)StringUtils.isEmptyOrElse((String)userAgent, (String)"unknown"), (Object)System.currentTimeMillis());
        }
    }

    public void incServiceCalls() {
        this.serviceCallCount.incrementAndGet();
    }

    private class StatisticsPersisterTask
    extends TimerTask {
        final /* synthetic */ ServiceStatisticsRecorder this$0;

        private StatisticsPersisterTask(ServiceStatisticsRecorder serviceStatisticsRecorder) {
            ServiceStatisticsRecorder serviceStatisticsRecorder2 = serviceStatisticsRecorder;
            Objects.requireNonNull(serviceStatisticsRecorder2);
            this.this$0 = serviceStatisticsRecorder2;
        }

        @Override
        public void run() {
            try {
                this.persistServiceCallCount();
                this.persistAndCleanLastAccessTime();
                this.persistProjectActivity();
                this.persistUserAgentStatistics();
            }
            catch (StorageException e) {
                LOGGER.error("Could not persist service statistics: " + e.getMessage(), (Throwable)e);
            }
        }

        private void persistServiceCallCount() throws StorageException {
            int serviceCalls = this.this$0.serviceCallCount.getAndSet(0);
            this.this$0.serviceLoadIndex.updateServiceCalls(System.currentTimeMillis(), serviceCalls);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void persistUserAgentStatistics() throws StorageException {
            TwoDimHashMap userAgentsCopy = new TwoDimHashMap();
            TwoDimHashMap<String, String, Long> twoDimHashMap = this.this$0.userAgents;
            synchronized (twoDimHashMap) {
                userAgentsCopy.putAll(this.this$0.userAgents);
                this.this$0.userAgents.clear();
            }
            this.this$0.userAgentsIndex.updateUserAgents(userAgentsCopy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void persistAndCleanLastAccessTime() throws StorageException {
            PairList usernameToLastActivityTimestamp;
            long entryCutoff = System.currentTimeMillis() - DurationUtils.ONE_MINUTE.toMillis();
            Map<String, Long> map = this.this$0.userLastActiveTime;
            synchronized (map) {
                usernameToLastActivityTimestamp = new PairList(this.this$0.userLastActiveTime);
                List removeKeys = CollectionUtils.filterAndMap(this.this$0.userLastActiveTime.entrySet(), entry -> (Long)entry.getValue() < entryCutoff, Map.Entry::getKey);
                CollectionUtils.removeAll(this.this$0.userLastActiveTime.keySet(), (List)removeKeys);
            }
            this.this$0.userLastActivityIndex.setLastActivity(usernameToLastActivityTimestamp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void persistProjectActivity() throws StorageException {
            SetMap userActivityCopy;
            long timestamp = System.currentTimeMillis();
            UnmodifiableIterator unmodifiableIterator = this.this$0.userActivity;
            synchronized (unmodifiableIterator) {
                userActivityCopy = new SetMap(new SetMap[]{this.this$0.userActivity});
                this.this$0.userActivity.clear();
            }
            for (PublicProjectId projectId : userActivityCopy.getKeys()) {
                Optional projectInfo = this.this$0.projectIndex.tryResolveProject((IProjectId)projectId);
                if (projectInfo.isEmpty()) continue;
                for (PublicProjectId projectKey : ((ProjectInfo)projectInfo.get()).getPublicIds()) {
                    this.this$0.projectUserActivityIndex.recordActivity(projectKey, userActivityCopy.getCollection((Object)projectId), timestamp);
                }
            }
        }
    }

    private class StatisticsWiperTask
    extends TimerTask {
        final /* synthetic */ ServiceStatisticsRecorder this$0;

        private StatisticsWiperTask(ServiceStatisticsRecorder serviceStatisticsRecorder) {
            ServiceStatisticsRecorder serviceStatisticsRecorder2 = serviceStatisticsRecorder;
            Objects.requireNonNull(serviceStatisticsRecorder2);
            this.this$0 = serviceStatisticsRecorder2;
        }

        @Override
        public void run() {
            try {
                this.this$0.userAgentsIndex.wipeExpiredData();
            }
            catch (StorageException e) {
                LOGGER.error("Could not wipe outdated service statistics: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

