/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service.client;

import java.net.URI;
import org.conqat.lib.commons.string.StringUtils;

public class ServiceCallException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String statusMessage = null;
    private int statusCode = 0;
    private String responseBody = null;

    public ServiceCallException(URI url, String statusMessage, int statusCode, String responseBody) {
        this(ServiceCallException.formatMessage(url, statusMessage, statusCode, responseBody));
        this.statusMessage = statusMessage;
        this.statusCode = statusCode;
        this.responseBody = responseBody;
    }

    public ServiceCallException(String message) {
        super(message);
    }

    public ServiceCallException(String message, int statusCode) {
        super(message);
        this.statusCode = statusCode;
    }

    public ServiceCallException(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceCallException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    private static String formatMessage(URI url, String statusMessage, int statusCode, String responseBody) {
        if (StringUtils.isEmpty((String)statusMessage)) {
            statusMessage = "(the server did not provide a detailed message)";
        }
        String message = "Request to '" + String.valueOf(url) + "' was not successful: " + statusCode + " " + statusMessage + ".";
        if (!StringUtils.isEmpty((String)responseBody)) {
            message = message + "\n" + responseBody;
        }
        return message;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

