/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metadata.abap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.ICounterSetMetricValue;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass
public enum EAbapLanguageVersion implements ICounterSetMetricValue
{
    UNKNOWN('~', "Unknown"),
    OBSOLETE_ABAP(' ', "Obsolete"),
    STANDARD_ABAP('X', "Standard"),
    ABAP_FOR_KEY_USERS('2', "Key Users"),
    STATIC_ABAP_WITH_RESTRICTED_OBJECT_USE('3', "Static ABAP (Restricted)"),
    STANDARD_ABAP_WITH_RESTRICTED_OBJECT_USE('4', "Standard ABAP (Restricted)"),
    ABAP_FOR_CLOUD_DEVELOPMENT('5', "Cloud");

    private static final String VERSION_ID_PROPERTY = "versionId";
    private static final String HUMAN_READABLE_NAME_PROPERTY = "humanReadableName";
    @JsonProperty(value="versionId")
    private final char versionId;
    @JsonProperty(value="humanReadableName")
    private final String humanReadableName;

    @JsonCreator
    private EAbapLanguageVersion(char versionId, String humanReadableName) {
        this.versionId = versionId;
        this.humanReadableName = humanReadableName;
    }

    public static EAbapLanguageVersion getLanguageVersionFromId(char versionId) {
        for (EAbapLanguageVersion languageVersion : EAbapLanguageVersion.values()) {
            if (languageVersion.versionId != versionId) continue;
            return languageVersion;
        }
        return UNKNOWN;
    }

    public char getVersionId() {
        return this.versionId;
    }

    public static CounterSet<EAbapLanguageVersion> toMetric(EAbapLanguageVersion langVersion) {
        if (langVersion == null || langVersion == UNKNOWN) {
            return new CounterSet((Object)UNKNOWN, 1);
        }
        return new CounterSet((Object)langVersion, 1);
    }

    @Override
    public String toUiMetricValueName() {
        return this.humanReadableName;
    }
}

