/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

final class TypeReferenceChecker {
    private TypeReferenceChecker() {
    }

    public static void checkFullyResolved(TypeReference<?> typeReference) {
        TypeReferenceChecker.checkFullyResolved(typeReference.getType());
    }

    private static void checkFullyResolved(Type type) {
        LinkedList<Type> toCheck = new LinkedList<Type>();
        toCheck.add(type);
        while (!toCheck.isEmpty()) {
            toCheck.addAll(TypeReferenceChecker.checkFullyResolved(type, (Type)toCheck.removeFirst()));
        }
    }

    private static Collection<Type> checkFullyResolved(Type rootType, Type toCheck) {
        Type type = toCheck;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class, GenericArrayType.class, WildcardType.class, TypeVariable.class}, (Type)type2, n)) {
            case 0 -> {
                Class ignored = (Class)type2;
                yield List.of();
            }
            case 1 -> {
                ParameterizedType parameterizedType = (ParameterizedType)type2;
                yield TypeReferenceChecker.checkFullyResolved(parameterizedType);
            }
            case 2 -> {
                GenericArrayType genericArrayType = (GenericArrayType)type2;
                yield TypeReferenceChecker.checkFullyResolved(genericArrayType);
            }
            case 3 -> {
                WildcardType wildcardType = (WildcardType)type2;
                yield TypeReferenceChecker.checkFullyResolved(rootType, wildcardType);
            }
            case 4 -> {
                TypeVariable typeVariable = (TypeVariable)type2;
                yield TypeReferenceChecker.checkFullyResolved(rootType, typeVariable);
            }
            default -> throw new UnsupportedOperationException(toCheck.getClass().toString());
        };
    }

    private static Collection<Type> checkFullyResolved(ParameterizedType parameterizedType) {
        return Stream.concat(Optional.ofNullable(parameterizedType.getOwnerType()).stream(), Arrays.stream(parameterizedType.getActualTypeArguments())).toList();
    }

    private static Collection<Type> checkFullyResolved(GenericArrayType genericArrayType) {
        return List.of(genericArrayType.getGenericComponentType());
    }

    private static Collection<Type> checkFullyResolved(Type rootType, WildcardType wildcardType) {
        List<Type> bounds = Stream.of(wildcardType.getLowerBounds(), wildcardType.getUpperBounds()).flatMap(Arrays::stream).toList();
        if (bounds.isEmpty() || bounds.size() == 1 && Object.class.equals((Object)bounds.getFirst())) {
            throw new IllegalArgumentException("Provided type '%s' must not include wildcards, but found '%s'".formatted(rootType.getTypeName(), wildcardType.getTypeName()));
        }
        return bounds;
    }

    private static Collection<Type> checkFullyResolved(Type rootType, TypeVariable<?> typeVariable) {
        throw new IllegalArgumentException("Provided type '%s' must not include type variables, but found '%s'".formatted(rootType.getTypeName(), typeVariable.getTypeName()));
    }
}

