/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.conqat.lib.commons.uniformpath.IUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class UniformPathModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public UniformPathModule() {
        this.addDeserializer(UniformPath.class);
        this.addDeserializer(IUniformPath.class);
    }

    private <T> void addDeserializer(Class<T> clazz) {
        UniformPathKeyDeserializer<T> keyDeserializer = new UniformPathKeyDeserializer<T>(clazz);
        this.addKeyDeserializer(clazz, keyDeserializer);
        this.addDeserializer(clazz, new UniformPathDeserializer<T>(keyDeserializer));
        if (clazz.isSealed()) {
            for (Class<?> subclass : clazz.getPermittedSubclasses()) {
                this.addDeserializer(subclass);
            }
        }
    }

    private static class UniformPathKeyDeserializer<U>
    extends KeyDeserializer {
        private final Class<U> targetType;

        public UniformPathKeyDeserializer(Class<U> targetType) {
            this.targetType = targetType;
        }

        public U deserializeKey(String key, DeserializationContext ctxt) throws JsonMappingException {
            UniformPath parsed = UniformPath.parse(key);
            if (!this.targetType.isInstance(parsed)) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Expected \"%s\" to be of type %s but was %s".formatted(key, this.targetType.getSimpleName(), parsed.getClass().getSimpleName()));
            }
            return this.targetType.cast(parsed);
        }
    }

    private static class UniformPathDeserializer<U>
    extends JsonDeserializer<U> {
        private final UniformPathKeyDeserializer<U> delegate;

        public UniformPathDeserializer(UniformPathKeyDeserializer<U> delegate) {
            this.delegate = delegate;
        }

        public U deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return this.delegate.deserializeKey(p.getValueAsString(), ctxt);
        }
    }
}

