/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass(containedInBackup=true)
public final class CommitDescriptor
implements Serializable,
Comparable<CommitDescriptor> {
    private static final String NO_BRANCH_NAME = "##no-branch##";
    private static final long serialVersionUID = 1L;
    private static final String BRANCH_NAME_PROPERTY = "branchName";
    private static final String TIMESTAMP_PROPERTY = "timestamp";
    @JsonProperty(value="branchName")
    private final @NonNull String branchName;
    @JsonProperty(value="timestamp")
    private final long timestamp;

    @JsonCreator
    public CommitDescriptor(@JsonProperty(value="branchName") @NonNull String branchName, @JsonProperty(value="timestamp") long timestamp) {
        CCSMAssert.isTrue((timestamp >= 0L ? 1 : 0) != 0, () -> "Timestamp must be >= 0 but is " + timestamp);
        CCSMAssert.isNotNull((Object)branchName);
        this.branchName = branchName;
        this.timestamp = timestamp;
    }

    public static CommitDescriptor createUnbranchedDescriptor(long timestamp) {
        return new CommitDescriptor(NO_BRANCH_NAME, timestamp);
    }

    public CommitDescriptor cloneWithDecrementedTimestamp() {
        return new CommitDescriptor(this.branchName, this.timestamp - 1L);
    }

    public CommitDescriptor cloneWithIncrementedTimestamp() {
        return new CommitDescriptor(this.branchName, this.timestamp + 1L);
    }

    public CommitDescriptor cloneWithTimestamp(long timestamp) {
        return new CommitDescriptor(this.branchName, timestamp);
    }

    public CommitDescriptor cloneWithBranchName(String branchName) {
        return new CommitDescriptor(branchName, this.timestamp);
    }

    public @NonNull String getBranchName() {
        return this.branchName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isUnbranched() {
        return NO_BRANCH_NAME.equals(this.branchName);
    }

    public boolean isHeadCommit() {
        return this.timestamp == Long.MAX_VALUE;
    }

    public boolean isOnBranch(String branchName) {
        return this.getBranchName().equals(branchName);
    }

    public boolean isOnAnyBranch(Collection<String> branchNames) {
        return branchNames.contains(this.getBranchName());
    }

    public boolean isOnSameBranchAs(CommitDescriptor other) {
        return this.branchName.equals(other.branchName);
    }

    public boolean isAncestorOnSameBranchOf(CommitDescriptor other) {
        return this.timestamp < other.timestamp && this.isOnSameBranchAs(other);
    }

    public boolean isDescendantOnSameBranchOf(CommitDescriptor other) {
        return this.timestamp > other.timestamp && this.isOnSameBranchAs(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CommitDescriptor)) return false;
        CommitDescriptor that = (CommitDescriptor)obj;
        if (this.timestamp != that.timestamp) return false;
        if (!Objects.equals(this.branchName, that.branchName)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.branchName) ^ Long.hashCode(this.timestamp);
    }

    public String toString() {
        return this.branchName + "@" + this.timestamp;
    }

    @Override
    public int compareTo(@NonNull CommitDescriptor o) {
        int compare = Long.compare(this.timestamp, o.timestamp);
        if (compare == 0) {
            compare = this.branchName.compareTo(o.branchName);
        }
        return compare;
    }

    public static CommitDescriptor fromStringRepresentation(String representation) {
        int separatorPosition = representation.lastIndexOf("@");
        CCSMAssert.isTrue((separatorPosition >= 0 ? 1 : 0) != 0, () -> "Invalid string representation of commit descriptor: " + representation);
        String branch = representation.substring(0, separatorPosition);
        String timestamp = representation.substring(separatorPosition + 1);
        return new CommitDescriptor(branch, Long.parseLong(timestamp));
    }

    public static CommitDescriptor latestOnBranch(String branchName) {
        return new CommitDescriptor(branchName, Long.MAX_VALUE);
    }

    public String toServiceCallFormat() {
        return this.toUnresolvedCommitDescriptor().toString();
    }

    public UnresolvedCommitDescriptor toUnresolvedCommitDescriptor() {
        return new UnresolvedCommitDescriptor(this);
    }
}

