/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.CodeUniformPath;
import org.conqat.lib.commons.uniformpath.IVirtualCodeUniformPath;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Serialized externally by super-class")
public final class ArchitectureUniformPath
extends UniformPath
implements IVirtualCodeUniformPath {
    public static final String SEPARATOR = "-src-";
    public static final ArchitectureUniformPath ROOT = new ArchitectureUniformPath((UnmodifiableList<String>)CollectionUtils.emptyList(), -1);
    private final int separatorIndex;

    private ArchitectureUniformPath(UnmodifiableList<String> segments, int separatorIndex) {
        super(UniformPath.EType.ARCHITECTURE, segments);
        this.separatorIndex = separatorIndex;
    }

    public static ArchitectureUniformPath ofSegments(String ... segments) {
        return ArchitectureUniformPath.ofSegments(Arrays.asList(segments));
    }

    public static ArchitectureUniformPath ofSegments(List<String> segments) {
        return (ArchitectureUniformPath)UniformPath.EType.ARCHITECTURE.with(segments);
    }

    public static ArchitectureUniformPath parse(String path) {
        return (ArchitectureUniformPath)UniformPath.parse(UniformPath.EType.ARCHITECTURE, path);
    }

    static ArchitectureUniformPath of(UnmodifiableList<String> segments) {
        if (segments.isEmpty()) {
            return ROOT;
        }
        return new ArchitectureUniformPath(segments, segments.indexOf((Object)SEPARATOR));
    }

    public UnmodifiableList<String> getComponentPathSegments() {
        if (this.separatorIndex < 0) {
            return this.segments;
        }
        return this.segments.subList(0, this.separatorIndex);
    }

    public ArchitectureUniformPath getComponentPath() {
        if (this.separatorIndex < 0) {
            return this;
        }
        return ArchitectureUniformPath.of((UnmodifiableList<String>)this.segments.subList(0, this.separatorIndex));
    }

    public UnmodifiableList<String> getElementPathSegments() {
        this.verifyIsElementPath();
        return this.segments.subList(this.separatorIndex + 1, this.segments.size());
    }

    public CodeUniformPath getElementPath() {
        this.verifyIsElementPath();
        return CodeUniformPath.of((UnmodifiableList<String>)this.segments.subList(this.separatorIndex + 1, this.segments.size()));
    }

    @Override
    public UniformPath resolveToCodePath() {
        if (this.separatorIndex < 0) {
            return CodeUniformPath.of((UnmodifiableList<String>)this.segments);
        }
        return this.getElementPath();
    }

    private void verifyIsElementPath() {
        if (this.separatorIndex < 0) {
            throw new IllegalStateException("Not an element path: %s".formatted(this));
        }
    }

    @Override
    public ArchitectureUniformPath resolve(RelativeUniformPath relativeUniformPath) {
        return (ArchitectureUniformPath)this.doResolve(relativeUniformPath);
    }
}

