/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.teamscale.commons.utils.StringPool;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.js_export.NotExported;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.ArchitectureUniformPath;
import org.conqat.lib.commons.uniformpath.CodeScopeUniformPath;
import org.conqat.lib.commons.uniformpath.CodeUniformPath;
import org.conqat.lib.commons.uniformpath.ExecutionUnitUniformPath;
import org.conqat.lib.commons.uniformpath.IVirtualCodeUniformPath;
import org.conqat.lib.commons.uniformpath.IssueItemUniformPath;
import org.conqat.lib.commons.uniformpath.IssueQueryUniformPath;
import org.conqat.lib.commons.uniformpath.NonCodeUniformPath;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.SpecItemQueryUniformPath;
import org.conqat.lib.commons.uniformpath.SpecItemUniformPath;
import org.conqat.lib.commons.uniformpath.TestExecutionUniformPath;
import org.conqat.lib.commons.uniformpath.TestImplementationUniformPath;
import org.conqat.lib.commons.uniformpath.TestQueryUniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public abstract sealed class UniformPath
implements Comparable<UniformPath>,
Serializable
permits ArchitectureUniformPath, CodeScopeUniformPath, CodeUniformPath, ExecutionUnitUniformPath, IssueItemUniformPath, IssueQueryUniformPath, NonCodeUniformPath, SpecItemQueryUniformPath, SpecItemUniformPath, TestExecutionUniformPath, TestImplementationUniformPath, TestQueryUniformPath {
    private static final long serialVersionUID = 1L;
    protected static final String SEGMENT_SEPARATOR = "/";
    private static final Function<String, String> INTERN = StringPool::intern;
    static final String SEGMENTS_LIST_MAY_NOT_BE_NULL = "Segments list may not be null";
    private static final UnmodifiableSet<String> RELATIVE_SEGMENTS = CollectionUtils.asUnmodifiable(Set.of(".", ".."));
    private static final UnmodifiableMap<CharSequence, CharSequence> ESCAPE_MAP = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"/", (Object)"\\/"), Pair.createPair((Object)"\\", (Object)"\\\\")});
    protected final EType type;
    protected final UnmodifiableList<String> segments;
    private transient @Nullable String pathString;
    private transient int hash;
    private transient boolean hashIsZero;

    protected UniformPath(EType type, UnmodifiableList<String> segments) {
        Objects.requireNonNull(type, "type");
        if (!type.getPathType().isAssignableFrom(this.getClass())) {
            throw new AssertionError((Object)("Incorrect UniformPath implementation by " + String.valueOf(this.getClass())));
        }
        this.type = type;
        this.segments = Objects.requireNonNull(segments, "segments");
    }

    static UnmodifiableList<String> intern(List<String> segments) {
        return CollectionUtils.asUnmodifiable(segments.stream().map(INTERN).toList());
    }

    public static UniformPath ofSegments(String ... segments) {
        Preconditions.checkNotNull((Object)segments, (Object)SEGMENTS_LIST_MAY_NOT_BE_NULL);
        return UniformPath.ofSegments(Arrays.asList(segments));
    }

    public static UniformPath ofSegments(EType type, String ... segments) {
        Preconditions.checkNotNull((Object)segments, (Object)SEGMENTS_LIST_MAY_NOT_BE_NULL);
        return UniformPath.ofSegments(type, Arrays.asList(segments));
    }

    public static UniformPath ofSegments(EType type, List<String> segments) {
        if (segments.isEmpty()) {
            return type.root();
        }
        return type.with(segments);
    }

    private static @NonNull UniformPath ofSegmentsUnsafe(EType type, List<String> segments) {
        return type.create(UniformPath.intern(segments));
    }

    public static UniformPath ofSegments(List<String> segments) {
        Preconditions.checkNotNull(segments, (Object)SEGMENTS_LIST_MAY_NOT_BE_NULL);
        if (segments.isEmpty()) {
            return CodeUniformPath.ROOT;
        }
        return EType.parse(segments.getFirst()).orElse(EType.CODE).with(segments);
    }

    public static UniformPath parse(String path) {
        if ((path = path.trim()).isEmpty()) {
            return CodeUniformPath.ROOT;
        }
        return UniformPath.ofSegments(UniformPath.getAbsoluteSegments(path));
    }

    public static UniformPath parse(EType type, String path) {
        if ((path = path.trim()).isEmpty()) {
            return type.root();
        }
        return UniformPath.ofSegments(type, UniformPath.getAbsoluteSegments(path));
    }

    private static List<String> getAbsoluteSegments(String uniformPath) {
        Preconditions.checkNotNull((Object)uniformPath, (Object)"Uniform path must not be null");
        return RelativeUniformPath.resolveRelativeSegments(Arrays.asList(UniformPathUtils.splitPath(uniformPath.trim())));
    }

    private static void checkSegmentsValidity(List<String> segments) {
        for (String segment : segments) {
            UniformPath.checkSegmentValidity(segment, segments, StringUtils::isEmpty, "empty segment");
            UniformPath.checkSegmentValidity(segment, segments, arg_0 -> RELATIVE_SEGMENTS.contains(arg_0), "relative segment");
            UniformPath.checkSegmentValidity(segment, segments, UniformPath::containsUnescapedSlash, "contains unescaped slash");
        }
    }

    static boolean containsUnescapedSlash(String data) {
        int indexOfLastSlash = data.indexOf(47);
        while (indexOfLastSlash != -1) {
            if (indexOfLastSlash == 0 || data.charAt(indexOfLastSlash - 1) != '\\') {
                return true;
            }
            indexOfLastSlash = data.indexOf(47, indexOfLastSlash + 1);
        }
        return false;
    }

    private static void checkDoesNotStartWithProjectOrRepositoryName(List<String> segments) throws AssertionError {
        if (segments.size() > 1 && EType.parse(segments.get(1)).isPresent()) {
            String pathWithErrorHighlighting = "[" + segments.getFirst() + "]/" + StringUtils.concat(segments.subList(1, segments.size()), (String)SEGMENT_SEPARATOR);
            throw new IllegalArgumentException("Invalid path (includes project or repository information): " + pathWithErrorHighlighting);
        }
    }

    static void checkSegmentValidity(String segment, List<String> segments, Predicate<String> errorCheck, String errorDetailMessage) {
        if (errorCheck.test(segment)) {
            List pathSegmentsWithErrorHighlighting = CollectionUtils.map(segments, pathSegment -> {
                if (errorCheck.test((String)pathSegment)) {
                    return "[" + pathSegment + "]";
                }
                return pathSegment;
            });
            throw new IllegalArgumentException(String.format("Invalid path (%s): %s", errorDetailMessage, String.join((CharSequence)SEGMENT_SEPARATOR, pathSegmentsWithErrorHighlighting)));
        }
    }

    @Deprecated
    public static UniformPath root(EType type) {
        return type.root();
    }

    @Deprecated
    public static CodeUniformPath codeRoot() {
        return CodeUniformPath.ROOT;
    }

    @Deprecated
    public static TestImplementationUniformPath testImplementationRoot() {
        return TestImplementationUniformPath.ROOT;
    }

    @Deprecated
    public static TestExecutionUniformPath testExecutionRoot() {
        return TestExecutionUniformPath.ROOT;
    }

    @Deprecated
    public static ExecutionUnitUniformPath executableUnitRoot() {
        return ExecutionUnitUniformPath.ROOT;
    }

    @Deprecated
    public static NonCodeUniformPath nonCodeRoot() {
        return NonCodeUniformPath.ROOT;
    }

    @Deprecated
    public static SpecItemQueryUniformPath specItemQueryRoot() {
        return SpecItemQueryUniformPath.ROOT;
    }

    public static String escapeSegment(String segment) {
        if (".".equals(segment)) {
            return "\\.";
        }
        if ("..".equals(segment)) {
            return "\\.\\.";
        }
        return StringUtils.escapeChars((String)segment, ESCAPE_MAP);
    }

    public static String unescapeSegment(String segment) {
        if ("\\.".equals(segment)) {
            return ".";
        }
        if ("\\.\\.".equals(segment)) {
            return "..";
        }
        return StringUtils.unescapeChars((String)segment, ESCAPE_MAP);
    }

    public UniformPath getParent() {
        Preconditions.checkState((!this.segments.isEmpty() ? 1 : 0) != 0, (Object)"Cannot get the parent of the root path");
        return this.type.create((UnmodifiableList<String>)this.segments.subList(0, this.segments.size() - 1));
    }

    public boolean hasParent() {
        return !this.isRoot();
    }

    public String getLastSegment() {
        Preconditions.checkState((!this.segments.isEmpty() ? 1 : 0) != 0, (Object)"Cannot get the last segment of the root path");
        return (String)this.segments.getLast();
    }

    public RelativeUniformPath getSubPath(int numberOfTopLevelSegmentsToRemove) {
        Preconditions.checkArgument((numberOfTopLevelSegmentsToRemove <= this.segments.size() ? 1 : 0) != 0, (String)"Cannot remove more segments than are contained in this path: %s segments to remove, path is %s", (int)numberOfTopLevelSegmentsToRemove, (Object)this);
        return RelativeUniformPath.of((List<String>)this.segments.subList(numberOfTopLevelSegmentsToRemove, this.segments.size()));
    }

    public Optional<RelativeUniformPath> getSubPathAfter(String segment) {
        int separatorIndex = this.segments.indexOf((Object)segment);
        if (separatorIndex < 0) {
            return Optional.empty();
        }
        return Optional.of(RelativeUniformPath.of((List<String>)this.segments.subList(separatorIndex + 1, this.segments.size())));
    }

    public static boolean isValidPath(String uniformPath) {
        if (uniformPath == null) {
            return false;
        }
        try {
            UniformPath.parse(uniformPath);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Deprecated
    public UniformPath resolveToCodePath() {
        return this;
    }

    public final boolean isRoot() {
        return this.segments.isEmpty();
    }

    @Deprecated
    public boolean isCodePath() {
        return this.type == EType.CODE;
    }

    @Deprecated
    public Optional<CodeScopeName> getCodeScope() {
        throw new IllegalStateException("Path is not a code scope path");
    }

    @Deprecated
    public boolean isNonCodePath() {
        return this.type == EType.NON_CODE;
    }

    @Deprecated
    public boolean isArchitecturePath() {
        return this.type == EType.ARCHITECTURE;
    }

    @Deprecated
    public boolean isCodeScopesPath() {
        return this.type == EType.CODE_SCOPES;
    }

    @Deprecated
    public boolean isIssueItemPath() {
        return this.type == EType.ISSUE_ITEM;
    }

    @Deprecated
    public boolean isIssueQueryPath() {
        return this.type == EType.ISSUE_QUERY;
    }

    @Deprecated
    public boolean isSpecItemPath() {
        return this.type == EType.SPEC_ITEM;
    }

    @Deprecated
    public boolean isSpecItemQueryPath() {
        return this.type == EType.SPEC_ITEM_QUERY;
    }

    @Deprecated
    public boolean isTestImplementationPath() {
        return this.type == EType.TEST_IMPLEMENTATION;
    }

    @Deprecated
    public boolean isTestExecutionPath() {
        return this.type == EType.TEST_EXECUTION;
    }

    @Deprecated
    public boolean isTestQueryPath() {
        return this.type == EType.TEST_QUERY;
    }

    @Deprecated
    public boolean isExecutionUnit() {
        return this.type == EType.EXECUTION_UNIT;
    }

    @Deprecated
    public boolean isVirtualCodePath() {
        return this instanceof IVirtualCodeUniformPath;
    }

    public final EType getType() {
        return this.type;
    }

    public final UnmodifiableList<String> getPathSegments() {
        return this.segments;
    }

    public final String getPathSegmentsString() {
        return String.join((CharSequence)SEGMENT_SEPARATOR, this.segments);
    }

    public UniformPath resolve(String relativePath) {
        return this.resolve(RelativeUniformPath.of(relativePath));
    }

    public abstract UniformPath resolve(RelativeUniformPath var1);

    protected final <T extends UniformPath> T doResolve(RelativeUniformPath relativeUniformPath) {
        ArrayList<String> segments = new ArrayList<String>((Collection<String>)this.segments);
        segments.addAll((Collection<String>)relativeUniformPath.getSegments());
        return (T)UniformPath.ofSegments(this.type, RelativeUniformPath.resolveRelativeSegments(segments));
    }

    @Deprecated
    public CodeScopeUniformPath asCodeScopePath(CodeScopeName codeScopeName) {
        throw new UnsupportedOperationException("Cannot transform \"%s\" into a code-scope path".formatted(this));
    }

    public boolean hasAncestor(UniformPath ancestorPath) {
        if (this.type != ancestorPath.type) {
            return false;
        }
        UnmodifiableList<String> containingPathSegments = ancestorPath.segments;
        if (containingPathSegments.size() > this.segments.size()) {
            return false;
        }
        return this.segments.subList(0, containingPathSegments.size()).equals(containingPathSegments);
    }

    public boolean hasDescendant(UniformPath descendantPath) {
        if (this.type != descendantPath.type) {
            return false;
        }
        UnmodifiableList<String> descendantPathSegments = descendantPath.segments;
        if (descendantPathSegments.size() < this.segments.size()) {
            return false;
        }
        return this.segments.equals(descendantPathSegments.subList(0, this.segments.size()));
    }

    @Override
    public int compareTo(@NonNull UniformPath other) {
        int compareToResult = this.type.getPrefix().compareTo(other.type.getPrefix());
        if (compareToResult != 0) {
            if (this.isCodePath() || other.isCodePath()) {
                return this.toString().compareTo(other.toString());
            }
            return compareToResult;
        }
        for (int i = 0; i < Math.min(this.segments.size(), other.segments.size()); ++i) {
            compareToResult = ((String)this.segments.get(i)).compareTo((String)other.segments.get(i));
            if (compareToResult == 0) continue;
            return compareToResult;
        }
        return this.segments.size() - other.segments.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof UniformPath)) return false;
        UniformPath that = (UniformPath)o;
        if (this.type != that.type) return false;
        if (!this.segments.equals(that.segments)) return false;
        return true;
    }

    public final int hashCode() {
        int h = this.hash;
        if (h == 0 && !this.hashIsZero) {
            h = Objects.hash(new Object[]{this.type, this.segments});
            if (h == 0) {
                this.hashIsZero = true;
            } else {
                this.hash = h;
            }
        }
        return h;
    }

    @JsonValue
    public final String toString() {
        String computed = this.pathString;
        if (computed == null) {
            this.pathString = computed = this.computeToString();
        }
        return computed;
    }

    public String toStringAsMigrationFrontier() {
        return this.toString();
    }

    protected String computeToString() {
        return Stream.concat(Stream.of(this.type.getPrefix()), this.segments.stream()).collect(Collectors.joining(SEGMENT_SEPARATOR));
    }

    protected final Object writeReplace() {
        return new Ser(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }

    private void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type.ordinal());
        out.writeInt(this.segments.size());
        for (String segment : this.segments) {
            out.writeObject(segment);
        }
    }

    private static UniformPath readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte ordinal = in.readByte();
        int segmentCount = in.readInt();
        ArrayList<String> segments = new ArrayList<String>(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            segments.add(INTERN.apply((String)in.readObject()));
        }
        return EType.VALUES[ordinal].create((UnmodifiableList<String>)UnmodifiableList.of(segments));
    }

    @ExportToTypeScript
    @IndexValueClass
    public static enum EType {
        CODE("-code-", CodeUniformPath.class, CodeUniformPath::of),
        NON_CODE("-non-code-", NonCodeUniformPath.class, NonCodeUniformPath::of),
        ARCHITECTURE("-architectures-", ArchitectureUniformPath.class, ArchitectureUniformPath::of),
        TEST_IMPLEMENTATION("-test-implementation-", TestImplementationUniformPath.class, TestImplementationUniformPath::of),
        TEST_EXECUTION("-test-execution-", TestExecutionUniformPath.class, TestExecutionUniformPath::of),
        TEST_QUERY("-test-query-", TestQueryUniformPath.class, TestQueryUniformPath::of),
        ISSUE_ITEM("-issue-item-", IssueItemUniformPath.class, IssueItemUniformPath::of),
        ISSUE_QUERY("-issues-", IssueQueryUniformPath.class, IssueQueryUniformPath::of),
        SPEC_ITEM("-spec-item-", SpecItemUniformPath.class, SpecItemUniformPath::of),
        SPEC_ITEM_QUERY("-spec-items-", SpecItemQueryUniformPath.class, SpecItemQueryUniformPath::of),
        EXECUTION_UNIT("-execution-unit-", ExecutionUnitUniformPath.class, ExecutionUnitUniformPath::of),
        CODE_SCOPES("-code-scopes-", CodeScopeUniformPath.class, CodeScopeUniformPath::of);

        private static final EType[] VALUES;
        private static final UnmodifiableMap<String, EType> PREFIX_TO_TYPE_MAPPING;
        private final String prefix;
        @NotExported
        private final Class<? extends UniformPath> pathType;
        @NotExported
        private final Function<UnmodifiableList<String>, ? extends UniformPath> factory;

        private EType(String prefix, Class<? extends UniformPath> pathType, Function<UnmodifiableList<String>, ? extends UniformPath> factory) {
            this.prefix = prefix;
            this.pathType = pathType;
            this.factory = factory.andThen(pathType::cast);
        }

        public static Optional<EType> parse(String typeString) {
            return Optional.ofNullable((EType)((Object)PREFIX_TO_TYPE_MAPPING.get((Object)typeString)));
        }

        public static EType valueOf(int ordinal) {
            return VALUES[ordinal];
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Class<? extends UniformPath> getPathType() {
            return this.pathType;
        }

        public UniformPath root() {
            return this.create((UnmodifiableList<String>)CollectionUtils.emptyList());
        }

        public UniformPath with(String ... segments) {
            return this.with(Arrays.asList(segments));
        }

        public UniformPath with(List<String> segments) {
            Preconditions.checkNotNull(segments, (Object)UniformPath.SEGMENTS_LIST_MAY_NOT_BE_NULL);
            UniformPath.checkSegmentsValidity(segments);
            UniformPath.checkDoesNotStartWithProjectOrRepositoryName(segments);
            Optional<EType> pathType = EType.parse(segments.getFirst());
            if (pathType.isPresent()) {
                if (pathType.get() != this) {
                    throw new IllegalArgumentException("Uniform path of type " + String.valueOf((Object)this) + " did start with " + segments.getFirst());
                }
                segments = segments.subList(1, segments.size());
            }
            return this.create(UniformPath.intern(segments));
        }

        private UniformPath create(UnmodifiableList<String> segments) {
            return this.factory.apply(segments);
        }

        static {
            VALUES = EType.values();
            PREFIX_TO_TYPE_MAPPING = CollectionUtils.asUnmodifiable(Arrays.stream(VALUES).collect(Collectors.toMap(EType::getPrefix, Function.identity())));
        }
    }

    private static final class Ser
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private UniformPath delegate;

        public Ser(UniformPath delegate) {
            this.delegate = delegate;
        }

        public Ser() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.delegate.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.delegate = UniformPath.readExternal(in);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }
}

