Missing or misused access rule annotations can lead to unauthorized access to ABAP CDS entities.
# What Does This Check Look For?

This check searches for `@AccessControl.authorizationCheck` annotations before an ABAP CDS view definition and checks
depending on the given parameter if the defined view gets used in at least one access control object.
Also checks if access control objects use a certain view but the view does not declare this in its annotation.

If `@AccessControl.authorizationCheck` is set to `#CHECK` or `#MANDATORY`, the view must be used in at least one access control object.
Otherwise, the view is not allowed to get used in any access control object.

The difference between `#CHECK` and `#MANDATORY` is:
- `#CHECK` issues a syntax warning if no access control exists
- `#MANDATORY` triggers a runtime error in ABAP SQL if the entity is accessed without an associated access control (introduced in SAP S/4HANA 2023)

# Check Options

- **Access control authorization - suppress findings**: Suppresses findings for `#NOT_ALLOWED` and `#NOT_REQUIRED` annotation values, except a corresponding DCL role exists.
- **Access control authorization - require MANDATORY**: When enabled, only `#MANDATORY` is accepted as authorization check value. Views using `#CHECK` will produce findings.

# Why is This a Problem?

A violation may lead to unauthorized access to _ABAP CDS_ entities.
