This check detects cartesian queries using `,` or `CROSS JOIN`.

# Why is This a Problem?
When using `CROSS JOIN` (explicit) or joins using `,` without a `WHERE` clause (implicit) to query data of two or more tables, PL/SQL will perform a so-called cartesian query.
This means, that the cartesian product of the joined tables will be calculated, i.e. the combination of each row the first table with each row of the second table and so forth.

Hence, cartesian queries can produce huge amounts of data depending on the size of the joined table and impact the performance.

# How Can I Resolve This?
Instead of cartesian queries, where all the data is joined, you should restrict the query to the data required in the respective statement.
For this, you can use `WHERE` clauses to define data on which the tables should be joined or use predefined `JOIN` expressions except `CROSS JOIN` (see references).


Note: Queries can be restricted using different `JOIN` constructs or clauses like `WHERE` (see references) whose use is dependent on the desired query result.

## Example (Before)

```oraclesqlplus
SELECT * FROM SOME_TABLE , SOME_OTHER_TABLE;
SELECT * FROM SOME_TABLE CROSS JOIN SOME_OTHER_TABLE;
```

## Example (After)

```oraclesqlplus
-- compliant: join based on values of the data field
SELECT * FROM SOME_TABLE , SOME_OTHER_TABLE WHERE SOME_TABLE.someDataField = SOME_OTHER_TABLE.someOtherDataField;
SELECT * FROM SOME_TABLE INNER JOIN SOME_OTHER_TABLE ON SOME_TABLE.someDataField = SOME_OTHER_TABLE.someOtherDataField; 
```

# Where Can I Learn More?

## References
- [Oracle Documentation: JOIN operations](https://docs.oracle.com/javadb/10.6.2.1/ref/rrefsqlj29840.html)
- [Oracletutorial: Oracle Joins](https://www.oracletutorial.com/oracle-basics/oracle-joins/)