Including a valid copyright header is important for protecting intellectual property rights.
Consider adding a standardized copyright header to files lacking one.

# What Does This Check Look For?

This check searches for files without a valid copyright header or with a header that does not meet the predefined standard.

# Why is This a Problem?

A missing or invalid copyright header can lead to legal uncertainties regarding the ownership and licensing of the source code.
It ensures clarity about the copyright status and usage permissions for the code, which is crucial for both open-source and proprietary projects.
Proper documentation in this aspect aids in maintaining the project's legal integrity.

# How Can I Resolve This?

Add a valid copyright header at the beginning of the file, based on your project's licensing requirements.
If unsure about the correct format, consult your legal department or refer to existing standards within your project or organization.
This action not only secures your rights but also clarifies usage permissions for others.

# Examples

## Non-Compliant

```java
package com.example.project;

public class Example {
    // ...
}
```

## Compliant

```java
/* Copyright 2023 Example Corporation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.example.project;

public class Example {
    // ...
}
```
