Using non-ASCII characters in comments can introduce inconsistencies and hinder readability.
Instead, it is recommended to use ASCII characters.


# What Does This Check Look For?

This check identifies comments containing non-ASCII characters. 

# Why is This a Problem?

Non-ASCII characters can lead to several issues:
1. **Encoding.**
   In the past, before a standard character encoding system was established,
   different regions and countries used different character sets for non-ASCII characters such as Δ or Λ.
   This caused inconsistencies in the encoding of characters across different regions,
   i.e., the identifier for a particular character in one region could represent a different character in another region.
2. **Tool Support.**
   While most compilers recognize non-ASCII characters, there is a possibility that your compiler might not support them.
3. **Internationalization.**
   Exclusively using ASCII characters and english vocabulary in the codebase enables international users
   to understand and work on the code.
   Using non-ASCII characters might confuse developers trying to understand your comments.

# How Can I Resolve This?

To maintain code clarity and ease of understanding:
- Prefer using ASCII characters within comments.
- If conveying special characters is necessary, consider using their ASCII equivalents or explaining them explicitly.

# Examples

## Non-Compliant

This example uses Java, but the principle generalizes to other languages.

```java
/**
* Computes the price in £ and € 
*/
public static int[] price(){
		int maisstaerke = 10;
		int inPound = 2;
		int inEuro = 1.5;

		int priceUK = maisstaerke * inPound;
		int priceEuropean = maisstaerke * inEuro;
		return new int[] {priceUK, priceEuropean};
}

```

## Compliant

```java
/**
 * Computes the price in GBP and EUR 
 */
public static int[] price(){
        int maisstaerke = 10;
        int inPound = 2;
        int inEuro = 1.5;

        int priceUK = maisstaerke * inPound;
        int priceEuropean = maisstaerke * inEuro;
        return new int[] {priceUK, priceEuropean};
        }

```