Executable programs without an **AUTHORITY-CHECK** may expose sensitive operations or data.
Ensure that an **AUTHORITY-CHECK** statement is placed appropriately to validate the user's permissions.

# What Does This Check Look For?

This check identifies executable programs defined with the `REPORT` or `PROGRAM` statement that lack an explicit `AUTHORITY-CHECK` before any executable statement is run.

# Why is This a Problem?

Lacking `AUTHORITY-CHECK` in executable programs can lead to security vulnerabilities, as unauthorized users might execute operations or access data they should not have access to. 
This is particularly critical since programs can be invoked by other programs using the `SUBMIT` statement without any implicit authority verification by the system. 
Thus, ensuring that each program performs its own authority checks is essential for maintaining both data integrity and the security of the application.

# How Can I Resolve This?

To mitigate the issue, place an `AUTHORITY-CHECK` statement at the start of the `INITIALIZATION` or `START-OF-SELECTION` event block, or before the first executable statement if these event blocks are not used. 
This checks the user's permissions against the authorization object before performing any further actions. 
If you are using custom authority check procedures, ensure they encapsulate the `AUTHORITY-CHECK` statement effectively, and configure them in the analysis profile to prevent false positives. 
(If you do not have permissions to update Teamscale's analysis profile, ask your Teamscale support person to do so.)

# Examples

## Non-Compliant

```abap
REPORT z_example_report.

START-OF-SELECTION.
  WRITE 'Executing sensitive operations'.
```

## Compliant

```abap
REPORT z_example_report.

START-OF-SELECTION.
AUTHORITY-CHECK OBJECT 'S_PROGRAM'
    ID 'ACTVT' FIELD '02'.

IF sy-subrc = 0.
  WRITE 'Executing sensitive operations'.
ENDIF.
```

# Where Can I Learn More?

- [ABAP - Keyword Documentation: AUTHORITY-CHECK](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abenbc_authority_check.htm)
- [SAP Community: How to Put Proper Authority-checks to Your Custom Programs](https://community.sap.com/t5/application-development-blog-posts/how-to-put-proper-authority-checks-to-your-custom-programs/ba-p/13029459)
