Unannotated methods in JUnit test classes might unintentionally be overlooked by JUnit.
Consider adding an appropriate JUnit annotation or modifying the method's access modifier.

# What Does This Check Look For?

This check identifies methods within JUnit 4 or 5 test classes that lack JUnit-specific annotations and are likely intended to be test methods.
The check flags two types of unannotated methods:

1. **Methods following the test naming convention**: Methods whose name starts with `test` (non-abstract, non-static, parameterless)
2. **Public methods**: Public, non-abstract, non-static, parameterless methods

The check only applies to classes that match the test class name pattern (default: `.*Test$`, configurable)


# Why is This a Problem?

Without the proper annotations, JUnit will not execute test methods, and setup/teardown operations will be skipped.
This could mask bugs or lead to a misunderstanding of code coverage, as these methods appear in the codebase but are never executed.

# How Can I Resolve This?

Review the method to determine its intended role within the test class:

- **Test method**: Add `@Test`, `@RepeatedTest`, or `@ParameterizedTest`
- **Setup method**: Add `@BeforeEach`/`@Before` (per-test) or `@BeforeAll`/`@BeforeClass` 
- **Teardown method**: Add `@AfterEach`/`@After` (per-test) or `@AfterAll`/`@AfterClass` 
- **Helper method**: Change access modifier to `private` or `protected`

# Examples

## Non-Compliant

```java
public class ExampleTest {
    public void testMethod() { // non-compliant: starts with "test" but missing annotation
        // test code
    }

    public void helperMethod() { // non-compliant: public parameterless method without annotation
        // helper code
    }
}
```

## Compliant

```java
public class ExampleTest {
    @Test
    public void testMethod() { // compliant: annotated with @Test
        // test code
    }

    private void helperMethod() { // compliant: private method
        // helper code
    }
}
