Measurable quantities without units can lead to ambiguities and pose challenges in interpretation.
To ensure clear, unambiguous specifications, all numbers representing measurable quantities should be accompanied by their respective units of measure.

# What Does This Check Look For?

This check detects item specifications that contain numbers without explicitly stated units of measure.

# Why is This a Problem?

Numbers without any unit of measure can lead to misunderstandings, possibly causing software defects. 
Such misinterpretations can lead to avoidable rework and even functional, performance or safety implications depending on the criticality of the system being developed.

# How Can I Resolve This?

Ensure to specify an appropriate unit of measure for every measurable quantity mentioned in the item's fields.

# Examples
## Non-Compliant

```markdown
# Spec Item Title
Type: Requirement
Description: The system should respond within 5.     // non-compliant: The unit of measure for 5 is not stated.
```

## Compliant

```markdown
# Spec Item Title
Type: Requirement
Description: The system should respond within 5s.     // compliant: The unit of measure now accompanies the number.
```

# Where Can I Learn More?
- Guideline: INCOSE Systems Engineering Handbook: 4th Edition - Requirement Writing Rules. R6 (Page 102)
- [Guideline: NASA Systems Engineering Handbook - Measure System and Element Performance (Page 110)](https://www.nasa.gov/sites/default/files/atoms/files/nasa_systems_engineering_handbook.pdf)
