Vague expressions and words add ambiguity and open room for interpretation.
Avoid their use and use clear and concise formulations instead.

# What Does This Check Look For?

This check detects expressions that are ambiguous or imprecise such as "may", "can", or "should".

# Why is This a Problem?

Using vague expressions or words adds ambiguity and opens room for interpretation.
This hampers comprehension since it is unclear what the idea of a test is.
Furthermore, executions of the same test are not comparable as the test results depend on the interpretation of the individual tester who performs the test.

According to RFC 2119 [1]:
* **'may'** means "an item is truly optional."[1].
This is not a good choice in a test description because a test outcome shall be reproducible, and the test case shall be deterministic.
* **'can'** only indicates a possibility or capability.
However, a test case shall define explicitly _how_ to test a possibility or a capability, not just state that it exists.
* **'should'** implies "that there may exist valid reasons in particular circumstances to ignore a particular item"[1].
Therefore, testers might pass a test even if the expected result, described as 'should', does not occur.

# How Can I Resolve This?

Avoid the use of vague expressions and words.
Instead, use clear and concise formulations that do not leave room for interpretation.

In particular: 
* **"May"**:
Instead of describing that something may be possible, the test case should state explicitly what actions the tester needs to perform to test the possibility.
* **"Can"**:
State explicitly what actions the tester needs to perform to test the capability.
* **"Should"**:
Use "shall" instead of "should" to make clear that an expected result in the test description is required, and not only recommended, to pass the test.

# Examples

## Non-Compliant:
```Markdown
The user may change the color scheme.
// or
The user can change the color scheme.
// or
The "Preferences" view should contain a drop-down "color scheme".
```

## Compliant:
```Markdown
The "Preferences" view shall contain a drop-down "color scheme".
```

# Where can I learn more?

* [1] [Request for Comments 2119: Key words for use in RFCs to Indicate Requirement Levels](https://www.rfc-editor.org/rfc/rfc2119)
