Assures bounded iterative behavior in generated code when using a For Iterator block. 
The following 3 conditions shall be satisfied:

1. The block's "Iteration limit source" parameter shall be set to "internal". 
    If it must be set to "external", the parameter shall have a block with constant value as its source. 
    Such blocks with constant value are Constant, Probe and Width type blocks. 
    Inport and Outport blocks are skipped over in order to enter/exit Subsystems while searching for the source block.
2. The block's "Set next i (iteration variable) externally" parameter shall not be selected.
3. The block's "Show iteration variable" parameter shall be selected.

## Guidelines

- [High-Integrity Modeling Guideline](https://mathworks.com/help/simulink/mdl_gd/hi/ports-subsystems.html#sl_0008)

## References

- Corresponding Model Advisor check [HISM hisl_0008](https://www.mathworks.com/help/slcheck/ref/check-usage-of-for-iterator-blocks.html)

