<h2>Why is this an issue?</h2>
<p>Assertions comparing incompatible types always fail, and negative assertions always pass. At best, negative assertions are useless. At worst, the
developer loses time trying to fix his code logic before noticing wrong assertions.</p>
<p>Dissimilar types are:</p>
<ul>
  <li> comparing a primitive with null </li>
  <li> comparing an object with an unrelated primitive (E.G. a string with an int) </li>
  <li> comparing unrelated classes </li>
  <li> comparing an array to a non-array </li>
  <li> comparing two arrays of dissimilar types </li>
</ul>
<p>This rule also raises issues for unrelated <code>class</code> and <code>interface</code> or unrelated <code>interface</code> types in negative
assertions. Because except in some corner cases, those types are more likely to be dissimilar. And inside a negative assertion, there is no test
failure to inform the developer about this unusual comparison.</p>
<p>Supported test frameworks:</p>
<ul>
  <li> JUnit4 </li>
  <li> JUnit5 </li>
  <li> AssertJ </li>
</ul>
<h3>Noncompliant code example</h3>

```java
interface KitchenTool {}
interface Plant {}
class Spatula implements KitchenTool {}
class Tree implements Plant {}

void assertValues(int size,
                  Spatula spatula, KitchenTool tool,  KitchenTool[] tools,
                  Tree    tree,    Plant       plant, Tree[]        trees) {

  // Whatever the given values, those negative assertions will always pass due to dissimilar types:
  assertThat(size).isNotNull();           // Noncompliant; primitives can not be null
  assertThat(spatula).isNotEqualTo(tree); // Noncompliant; unrelated classes
  assertThat(tool).isNotSameAs(tools);    // Noncompliant; array & non-array
  assertThat(trees).isNotEqualTo(tools);  // Noncompliant; incompatible arrays

  // Those assertions will always fail
  assertThat(size).isNull();                       // Noncompliant
  assertThat(spatula).isEqualTo(tree);             // Noncompliant

  // Those negative assertions are more likely to always pass
  assertThat(spatula).isNotEqualTo(plant); // Noncompliant; unrelated class and interface
  assertThat(tool).isNotEqualTo(plant);    // Noncompliant; unrelated interfaces
}
```
<h2>Resources</h2>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S2159'>java:S2159</a> - Silly equality checks should not be made </li>
</ul>