# Description
Downport functionality

# Extended Information
Much like the 'commented_code' rule this rule loops through unknown statements and tries parsing with
a higher level language version. If successful, various rules are applied to downport the statement.
Target downport version is always v702, thus rule is only enabled if target version is v702.

Current rules:
* `NEW` transformed to `CREATE OBJECT`, opposite of https://rules.abaplint.org/use_new/
* `DATA()` definitions are outlined, opposite of https://rules.abaplint.org/prefer_inline/
* `FIELD-SYMBOL()` definitions are outlined
* `CONV` is outlined
* `COND` is outlined
* `REDUCE` is outlined
* `SWITCH` is outlined
* `FILTER` is outlined
* `APPEND` expression is outlined
* `INSERT` expression is outlined
* `EMPTY KEY` is changed to `DEFAULT KEY`, opposite of `DEFAULT KEY` in https://rules.abaplint.org/avoid_use/
* `CAST` changed to `?=`
* `LOOP AT method_call( )` is outlined
* `VALUE #` with structure fields
* `VALUE #` with internal table lines
* Table Expressions are outlined
* `SELECT INTO @DATA` definitions are outlined
* Some occurrences of string template formatting option `ALPHA` changed to function module call
* `SELECT`/`INSERT`/`MODIFY`/`DELETE`/`UPDATE` "," in field list removed, "@" in source/targets removed
* `PARTIALLY IMPLEMENTED` removed, it can be quick fixed via rule `implement_methods`
* `RAISE EXCEPTION` ... `MESSAGE`
* Moving with `+=`, `-=`, `/=`, `*=`, `&&=` is expanded
* `line_exists` and `line_index` is downported to `READ TABLE`
* `ENUM`s, but does not necessarily give the correct type and value
* `MESSAGE` with non simple source

Only one transformation is applied to a statement at a time, so multiple steps might be required to do the full downport.

Make sure to test the downported code, it might not always be completely correct.

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/downport) <br>
