# Description
Detects nested ifs which can be refactored.

# Extended Information
Nested `IF`s get hard to understand very quickly and require an exponential number of test cases for complete coverage.

Decision trees can usually be taken apart by forming sub-methods and introducing boolean helper variables.

Other cases can be simplified by merging `IF`s instead of the needlessly nesting them.

# Examples
**Bad example**
```abap
IF condition1.
  IF condition2.
    ...
  ENDIF.
ENDIF.

IF condition1.
  ...
ELSE.
  IF condition2.
    ...
  ENDIF.
ENDIF.
```

**Good example**
```abap
IF ( condition1 ) AND ( condition2 ).
  ...
ENDIF.

IF condition1.
  ...
ELSEIF condition2.
  ...
ENDIF.

CASE variable.
  WHEN value1.
  ...
  WHEN value2.
    IF condition2.
      ...
    ENDIF.
ENDCASE.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/if_in_if) <br>
The contents within section `Extended Information` were copied (without code examples) from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
