Mako is a Python templating system often used to build web applications. It is
the default templating system used in Pylons and Pyramid. Unlike Jinja2 (an
alternative templating system), Mako has no environment wide variable escaping
mechanism. Because of this, all input variables must be carefully escaped
before use to prevent possible vulnerabilities to Cross Site Scripting (XSS)
attacks.


## Example


In the following code snippet the issue is: Mako templates allow HTML/JS rendering by default and are
inherently open to XSS attacks. Ensure variables in all templates are
properly sanitized via the 'n', 'h' or 'x' flags (depending on context).
For example, to HTML escape the variable 'data' do ${ data |h }.
For more information on this see: CWE-80 (https://cwe.mitre.org/data/definitions/80.html)
``` python

 mako.template.Template("hern")
 template.Template("hern")
```
## see also:

- https://www.makotemplates.org/
- `OWASP XSS <https://owasp.org/www-community/attacks/xss/>`_
- https://security.openstack.org/guidelines/dg_cross-site-scripting-xss.html
- https://cwe.mitre.org/data/definitions/80.html

New in version  0.10.0

Changed in version  1.7.3
CWE information added
