# Rule 10.4 Both operands of an operator in which the usual arithmetic conversions are performed shall have the same essential type category

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
This rule applies to operators that are described in usual arithmetic conversions (see C90 Section 6.2.1.5, C99 Section 6.3.1.8). This includes all the binary operators, excluding the shift, logical &&, logical || and comma operators. In addition, the second and third operands of the ternary operator are covered by this rule.

Note: the increment and decrement operators are not covered by this rule.

## Rationale
The C language allows the programmer considerable freedom and will permit conversions between different arithmetic types to be performed automatically. However, the use of these implicit conversions can lead to unintended results, with the potential for loss of value, sign or precision. Further details of concerns with the C type system can be found in Appendix C.

The use of stronger typing, as enforced by the MISRA essential type model, allows implicit conversions to be restricted to those that should then produce the answer expected by the developer.

## Exception
The following are permitted to allow a common form of character manipulation to be used:
1.  The binary + and += operators may have one operand with essentially character type and the other operand with an essentially signed or essentially unsigned type;
2.  The binary - and -= operators may have a left-hand operand with essentially character type and a right-hand operand with an essentially signed or essentially unsigned type.

## Example
```c
enum enuma { A1, A2, A3 } ena;
enum enumb { B1, B2, B3 } enb;
```

The following are compliant as they have the same essential type category:

```c
ena > A1
u8a + u16b
```

The following is compliant by exception 1:

```c
cha += u8a
```

The following is non-compliant with this rule and also violates Rule 10.3:

```c
s8a += u8a    /* signed and unsigned */
```

The following are non-compliant:

```c
u8b + 2       /* unsigned and signed */
enb > A1      /* enum<enumb> and enum<enuma> */
ena == enb    /* enum<enuma> and enum<enumb> */
u8a += cha    /* unsigned and char */
```

## See also
Rule 10.3, Rule 10.7

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
