# Rule 11.8 A cast shall not remove any const or volatile qualification from the type pointed to by a pointer

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
Any attempt to remove the qualification associated with the addressed type by using casting is a violation of the principle of type qualification.

Note: the qualification referred to here is not the same as any qualification that may be applied to the pointer itself.

Some of the problems that might arise if a qualifier is removed from the addressed object are:
*   Removing a const qualifier might circumvent the read-only status of an object and result in it being modified;
*   Removing a const qualifier might result in an exception when the object is accessed;
*   Removing a volatile qualifier might result in accesses to the object being optimized away.

Note: removal of the C99 restrict type qualifier is benign.

## Example
```c
         uint16_t x;
         uint16_t * const cpi = &x;  /* const pointer              */
         uint16_t * const *pcpi;     /* pointer to const pointer   */
         uint16_t * *ppi;
   const uint16_t *pci;              /* pointer to const           */
volatile uint16_t *pvi;              /* pointer to volatile        */
         uint16_t *pi;

pi = cpi;                 /* Compliant - no conversion
                             no cast required          */

pi = (uint16_t *)pci;     /* Non-compliant */
pi = (uint16_t *)pvi;     /* Non-compliant */
ppi = (uint16_t * *)pcpi; /* Non-compliant */
```

## See also
Rule 11.3

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
