# Rule 17.4 All exit paths from a function with non-void return type shall have an explicit return statement with an expression
## Category
Mandatory
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
The expression given to the *return* statement provides the value that the function returns. If a *non-void* function does not return a value but the calling function uses the returned value, the behaviour is undefined. This can be avoided by ensuring that, in a *non-void* function:
- Every *return* statement has an expression, and
- Control cannot reach the end of the function without encountering a *return* statement.
Note: C99 and later *constrain* every *return* statement in a *non-void* function to return a value.
## Exception
For C99 and later, the C Standard specifies that if control reaches the end of `main` without encountering a *return* statement, the effect is that of executing `return 0`. Therefore, for C99 and later, the *return* statement may be omitted for function `main`.
## Example
```c
int32_t absolute ( int32_t v )
{
 if ( v < 0 )
 {
 return v;
 }
 /*
 * Non-compliant - control can reach this point without
 * returning a value
 */
}

uint16_t lookup ( uint16_t v )
{
 if ( ( v < V_MIN ) || ( v > V_MAX ) )
 {
 /* Non-compliant - no value returned. Constraint in C99 and later */
 return;
 }
 return table[ v ];
}
```
## See also
Rule 15.5

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
