# Rule 20.4 A macro shall not be defined with the same name as a keyword
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
This rule applies to all keywords, including those that implement language extensions.
## Rationale
Using macros to change the meaning of keywords can be confusing. The behaviour is undefined if a standard header is included while a macro is defined with the same name as a keyword.
## Example
```c
/* The following example is non-compliant because it alters the behaviour of the int keyword. Including a standard header in the presence of this macro results in undefined behaviour. */
#define int some_other_type
#include <stdlib.h>

/* The following example shows that it is non-compliant to redefine the keyword while but it is compliant to define a macro that expands to statements. */
#define while( E ) for ( ; ( E ) ; ) /* Non-compliant - redefined while */
#define unless( E ) if ( ! ( E ) ) /* Compliant */

#define seq( S1, S2 ) do { \
 S1; S2; } while ( false ) /* Compliant */
#define compound( S ) { S; } /* Compliant */

/* The following example is only compliant with C90. */
/* Remove inline if compiling for C90 */
#define inline
```
## See also
Rule 21.1

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
