# Dir 1.1 Any implementation-defined behaviour on which the output of the program depends shall be documented and understood 

## Category

Required 

## Applies to

C90, C99, C11 

## Amplification

Appendix G of this document lists those implementation-defined behaviours that: 
* Are considered to have the potential to cause unexpected program operation, and 
* May be present in a program even if it complies with all the other MISRA C guidelines. 

All of these implementation-defined behaviours on which the program output depends must be: 
* Documented, and 
* Understood by developers. 

Note: a conforming implementation is required to document its treatment of all implementation-defined behaviour. The developer of an implementation should be consulted if any documentation is missing. 

## Rationale

It is important to know that the output of a program was intentional and was not produced by chance. 

Some of the more common implementation-defined behaviours on which safety-related embedded software is likely to depend are described below. 

**Core behaviour**
The fundamental implementation-defined behaviours, which are likely to be required by most programs, include: 
* How to identify a diagnostic message produced during translation; 
* The type of the function main, commonly declared as void main (void) in freestanding implementations; 
* The number of significant characters in identifiers - needed to configure an analysis tool for Rule 5.2; 
* The source and execution character sets; 
* The sizes of the integer types; 
* How a #include'd name is mapped onto a file name and located in the host file system. 

**Extensions**
Extensions are often used in embedded systems to provide access to peripherals and to place objects into regions of memory with special properties such as Flash EEPROM or fast-access RAM. A conforming implementation is permitted to provide extensions provided that they do not alter the meaning of any strictly conforming program. 

An implementation may provide extensions which implement a subset of the features for a later edition of the C Standard. 

Some of the methods by which an implementation can provide extensions are: 
* The #pragma preprocessing directive or the_Pragma operator; 
* New keywords. 

**The Standard Library**
Some aspects of the Standard Library implementation that may be important are: 
* The values assigned to errno when certain Standard Library functions are used; 
* The implementation of clock and time functions; 
* The characteristics of the file system. 

**The Application Binary Interface**
It is sometimes necessary to interface C code with assembly language, for example to improve execution speed in those places where it is critical. It might also be necessary to interface code produced by different compilers, possibly for different languages. 

The Application Binary Interface (ABI) for a compiler provides the information necessary to perform this task, including some of the implementation-defined behaviours. It typically specifies: 
* How function parameters are passed in registers and on the stack; 
* How function values are returned; 
* Which registers must be preserved by a function; 
* How objects with automatic storage duration are allocated to stack frames; 
* Alignment requirements for each data type; 
* How structures are laid out and how bit-fields are allocated to storage units. 

Some processors have a standard ABI which will be used by all implementations. Where no standard ABI exists, an implementation will provide its own. 

**Integer division**
In C90, signed integer division or remainder operations in which either operand has a negative value may either round downwards or towards zero. In C99 and later, rounding is guaranteed to be towards zero. 

**Floating-point implementation**
The implementation of floating-point types can have significant impact on program behaviour, for example: 
* The range of values and the precision with which they are stored; 
* The direction of rounding following floating-point operations; 
* The direction of rounding when converting to narrower floating-point types or to integer types; 
* The behaviour in the presence of underflow, overflow and NaNs; 
* The behaviour of library functions in the event of domain and range errors. 

## See also

Rule 5.1, Rule 5.2 

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
