# Dir 4.8 If a pointer to a structure or union is never dereferenced within a translation unit, then the implementation of the object should be hidden 

## Category

Advisory 

## Applies to

C90, C99, C11 

## Amplification

The implementation of an object should be hidden by means of a pointer to an incomplete type. This directive only applies if all the pointers to a particular structure or union in a translation unit are never dereferenced. 

## Rationale

If a pointer to a structure or union is never dereferenced, then the implementation details of the object are not needed and its contents should be protected from unintentional changes. 

Hiding the implementation details creates an opaque type which may be referenced via a pointer but whose contents may not be accessed. 

## Example

```c
/* Opaque.h */
#ifndef OPAQUE_H
#define OPAQUE_H
typedef struct OpaqueType *pOpaqueType;
#endif

/* Opaque.c */
#include "Opaque.h"
struct OpaqueType
{
    /* Object implementation */
};

/* UseOpaque.c */
#include "Opaque.h"
void f (void)
{
    pOpaqueType pObject;
    pObject = GetObject ();
    UseObject (pObject); /* Get a handle to an OpaqueType object. Use it... */
}

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
