# Rule 14.4 The controlling expression of an *if* statement and the controlling expression of an *iteration-statement* shall have *essentially Boolean* type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
The controlling expression of a *for* statement is optional. The rule does not require the expression to be present but does require it to have *essentially Boolean type* if it is present.

## Rationale
Strong typing requires the controlling expression of an *if* statement or *iteration-statement* to have *essentially Boolean* type.

## Example
```c
int32_t *p, *q;

while ( p )             /* Non-compliant - p is a pointer */
{
}

while ( q != NULL )     /* Compliant */
{
}

while ( true )          /* Compliant */
{
}

extern bool_t flag;

while ( flag )          /* Compliant */
{
}

int32_t i;

if ( i )                /* Non-compliant */
{
}

if ( i != 0 )           /* Compliant */
{
}
```

## See also
Rule 11.11, Rule 14.2, Rule 20.8

---

Copyright The MISRA Consortium Limited © [Date - March 2025].