# Rule 18.6 The address of an object with automatic or thread-local storage shall not be copied to another object that persists after the first object has ceased to exist

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
The address of an object might be copied by means of:
*   *Assignment*;
*   Memory move or copying functions.

## Rationale
The address of an object becomes indeterminate when the lifetime of that object expires. Any use of an indeterminate address results in undefined behaviour.

## Example
```c
int8_t *func ( void )
{
  int8_t local_auto;
  return &local_auto;  /* Non-compliant - &local_auto is indeterminate
                        * when func returns                            */
}
```
In the following example, the function `g` stores a copy of its pointer parameter `p`. If `p` always points to an object with static storage duration then the code is compliant with this rule. However, in the example given, `p` does point to an object with automatic storage duration. In such a case, copying the parameter `p` is non-compliant.
```c
uint16_t *sp;

void g ( uint16_t *p )
{
  sp = p;              /* Non-compliant - address of f's parameter u
                        * copied to static sp                          */
}

void f ( uint16_t u )
{
  g ( &u );
}

void h ( void )
{
  static uint16_t *q;
  uint16_t x = 0u;

  q = &x;              /* Non-compliant - &x stored in object with
                        * greater lifetime                             */
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].