# Rule 15–3–7 (Required) Where multiple handlers are provided in a single try-catch statement or function-try-block, any ellipsis (catch-all) handler shall occur last.

## Rationale
If the catch-all handler is found before any other handler, that behaviour will be performed. Any handlers after the catch-all are unreachable code and can never be executed.

## Example
```c
void f1 ( ) 
{ 
 try 
 { 
 // ... 
 }
 catch ( int32_t i ) // int handler 
 { 
 // Handle int exceptions 
 }
 catch( ... ) // catch-all handler 
 { 
 // Handle all other exception types 
 } 
}
void f2 ( ) 
{ 
 try 
 { 
 // ... 
 }
 catch( ... ) // catch-all handler 
 { 
 // Handle all exception types 
 }
 catch ( int32_t i ) // Non-compliant – handler will never be called 
 { 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
