# Rule 5–0–11 (Required) The plain char type shall only be used for the storage and use of character values.

## Amplification
[Implementation 3.9.1(1), 7.1.5.2(1)]

## Rationale
The char type within C++ is defined for use with the implementation character set. It is implementation-defined if char is signed or unsigned, and it is therefore unsuitable for use with numeric data.
Character values consist of character literals or strings. A character set maps text characters onto numeric values; the character value is the text itself.
Note that Rule 3–9–2 applies, so this rule also covers the char_t type.

## Example
```c
char_t a = 'a'; // Compliant 
char_t b = '\r'; // Compliant 
char_t c = 10; // Non-compliant 
char d = 'd'; // Compliant with this rule, but breaks Rule 3–9–2
```

## See also
Rule 3–9–2, Rule 5–0–12

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
