# Rule 5–0–17 (Required) Subtraction between pointers shall only be applied to pointers that address elements of the same array.

## Amplification
[Undefined 5.7(6)]

## Rationale
This rule applies to expressions of the form:
pointer_expression_1 - pointer_expression_2
where pointer_expression_1 and pointer_expression_2 are pointers to array elements.
It is undefined behaviour if pointer_expression_1 and pointer_expression_2 do not point to elements of the same array or the element one beyond the end of that array.

## Example
```c
void f1 ( ) 
{ 
 int32_t a1[ 10 ]; 
 int32_t a2[ 10 ];
 int32_t * p1 = &a1 [ 1 ]; 
 int32_t * p2 = &a2 [ 10 ]; 
 int32_t diff;
 diff = p1 - a1; // Compliant 
 diff = p2 - a2; // Compliant 
 diff = p1 - p2; // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
