# Rule 19.1.3 All identifiers used in the controlling expression of #if or #elif preprocessing directives shall be defined prior to evaluation

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
As well as using a `#define` preprocessor directive, macro names may effectively be defined in other
*implementation-defined*, ways. For example some implementations support:
*   Using a compiler command-line option, such as `-D`, to allow macros to be defined prior to
translation;
*   Pre-defined macros provided by the compiler.

## Rationale
If an attempt is made to use an identifier in a preprocessor directive, and that identifier has not been
defined as a macro name, then the preprocessor will assume that it has a value of zero. This may not
meet developer expectations.

## Example
The following example assumes that the identifier `M` is not defined as a macro name.

```cpp
#if M == 0 // Non-compliant
#endif

#if defined( N ) // Compliant - N is not evaluated, even if not a macro
#if N == 0 // Compliant - N is known to be defined at this point
#endif
#endif

// Compliant - B is only evaluated in ( B == 0 ) if it is defined
#if defined( B ) && ( B == 0 )
#endif
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
