# Rule 15.3 Any label referenced by a *goto* statement shall be declared in the same block, or in any block enclosing the *goto* statement

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
For the purposes of this rule, a *switch-clause* that does not consist of a compound statement is treated
as if it were a block.

## Rationale
Unconstrained use of *goto* can lead to programs that are unstructured and extremely difficult to
understand.

Preventing jumps between blocks, or into nested blocks, helps to minimize visual code complexity.

*Note*: C99 is more restrictive when variably modified types are used. An attempt to make a jump from
outside the scope of an identifier with a variably modified type into such a scope results in a *constraint*
violation.

## Example
```c
void f1 ( int32_t a )
{
 if ( a <= 0 )
 {
 goto L2; /* Non-compliant */
 }
 goto L1; /* Compliant */
 if ( a == 0 )
 {
 goto L1; /* Compliant */
 }
 goto L2; /* Non-compliant */
L1:
 if ( a > 0 )
 {
 L2:
 ;
 }
}
```
In the following example, the label `L1` is defined in a block which encloses the block containing the
*goto* statement. However, the jump crosses from one *switch-clause* to another and, since *switch-clauses*
are treated like blocks for the purposes of this rule, the *goto* statement is non-compliant.
```c
switch ( x )
{
 case 0:
 if ( x == y )
 {
 goto L1;
 }
 break;
 case 1:
 y = x;
L1:
 ++x;
 break;
 default:
 break;
}
```

## See also
Rule 9.1, Rule 15.1, Rule 15.2, Rule 15.4, Rule 16.1

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
