# Rule 21.11 The standard header file `<tgmath.h>` shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C99

## Amplification
None of the facilities that are specified as being provided by `<tgmath.h>` shall be used.

## Rationale
Using the facilities of `<tgmath.h>` may result in undefined behaviour.

## Example
```c
#include <tgmath.h>
float f1, f2;
void f ( void )
{
 f1 = sqrt ( f2 ); /* Non-compliant - generic sqrt used */
}
#include <math.h>
float f1, f2;
void f ( void )
{
 f1 = sqrtf ( f2 ); /* Compliant - float version of sqrt used */
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
