# Rule 5.7 A tag name shall be a unique identifier

## Category
Required

## Analysis
Decidable, System

## Applies to
C90, C99

## Amplification
The tag shall be unique across all name spaces and translation units.

All declarations of the tag shall specify the same type.

Multiple complete declarations of the same tag are only permitted by this rule if the tag is declared in a *header file* and that *header file* is included in multiple source files.

## Rationale
Reusing a tag name may lead to developer confusion.

There is also undefined behaviour associated with reuse of tag names in C90 although this is not listed in The Standard’s Annex. This undefined behaviour was recognized in C99 as a *constraint* in Section 6.7.2.3.

## Exception
The tag name may be the same as the *typedef* name with which it is associated.

## Example
```c
struct stag
{
  uint16_t a;
  uint16_t b;
};

struct stag a1 = { 0, 0 }; /* Compliant - compatible with above */
union stag a2 = { 0, 0 };  /* Non-compliant - declares different type
                            * from struct stag.
                            * Constraint violation in C99 */
```

The following example also violates Rule 5.3

```c
struct deer
{
  uint16_t a;
  uint16_t b;
};

void foo ( void )
{
  struct deer
  {
    uint16_t a;
  }; /* Non-compliant - tag "deer" reused */
}

typedef struct coord
{
  uint16_t x;
  uint16_t y;
} coord; /* Compliant by Exception */

struct elk
{
  uint16_t x;
};

struct elk /* Non-compliant - declaration of different type
            * Constraint violation in C99 */
{
  uint32_t x;
};
```

## See also
Rule 5.6

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
