# Rule 11.2 Conversions shall not be performed between a pointer to an incomplete type and any other type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
A pointer to an incomplete type shall not be converted into another type.
A conversion shall not be made into a pointer to incomplete type.
Although a pointer to *void* is also a pointer to an incomplete type, this rule does not apply to pointers to *void* as they are covered by Rule 11.5.
This rule applies to the unqualified types that are pointed to by the pointers.
## Rationale
Conversion into or from a pointer to an incomplete type may result in a pointer that is not correctly aligned, resulting in undefined behaviour.
Conversion of a pointer to an incomplete type into or from a floating type always results in undefined behaviour.
Pointers to an incomplete type are sometimes used to hide the representation of an object. Converting a pointer to an incomplete type into a pointer to object would break this encapsulation.
## Exception
1. A *null pointer constant* may be converted into a pointer to an incomplete type.
2. A pointer to an incomplete type may be converted into *void*.
## Example
```c
struct s; /* Incomplete type */
struct t; /* A different incomplete type */
struct s *sp;
struct t *tp;
int16_t *ip;

#include <stdlib.h> /* To obtain macro NULL */

ip = ( int16_t * ) sp; /* Non-compliant */
sp = ( struct s * ) 1234; /* Non-compliant */
tp = ( struct t * ) sp; /* Non-compliant - casting pointer into a
 * different incomplete type */

sp = NULL; /* Compliant - exception 1 */

struct s *f ( void );

( void ) f ( ); /* Compliant - exception 2 */
```
## See also
Rule 11.5

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
