# Rule 21.11 The standard header file <tgmath.h> should not be used
## Category
Advisory
## Analysis
Decidable, Single Translation Unit
## Applies to
C99, C11
## Amplification
The standard header file `<tgmath.h>` should not be `#include`'d.
Note: Due to the duplication of macro names between `<tgmath.h>`, `<math.h>` and `<complex.h>` this rule does not have the additional requirement that *none of the features that are specified as being provided by `<tgmath.h>` should be used*, as use by means of `#including` either of these other standard *header files* is not constrained. Any other definition of a macro specified as being provided by `<tgmath.h>` will be a violation of Rule 21.1 and/or Rule 21.2.
## Rationale
Using the facilities of `<tgmath.h>` may result in undefined behaviour.
## Example
```c
#include <tgmath.h>
float f1, f2;

void f ( void )
{
 f1 = sqrt ( f2 ); /* Non-compliant - generic sqrt used */
}

#include <math.h>
float f1, f2;

void f ( void )
{
 f1 = sqrtf ( f2 ); /* Compliant - float version of sqrt used */
}
```
## See also
Rule 21.1, Rule 21.2, Rule 21.22, Rule 21.23

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
