# Rule 5.2 Identifiers declared in the same scope and name space shall be distinct

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Amplification

This rule does not apply if:
* both identifiers are external identifiers, because this case is covered by Rule 5.1, or
* either identifier is a macro identifier, because this case is covered by Rule 5.4 and Rule 5.5.

The definition of distinct depends on the implementation and on the edition of the C Standard that is being used:
* In C90 the minimum requirement is that the first 31 characters are significant;
* In C99 and later the minimum requirement is that the first 63 characters are significant, with each universal character or extended source character counting as a single character. 

## Rationale

If two identifiers differ only in non-significant characters, the behaviour is undefined.

If portability is a concern, it would be prudent to apply this rule using the minimum limits specified in the C Standard.

Long identifiers may impair the readability of code. While many automatic code generation systems produce long identifiers, there is a good argument for keeping identifier lengths well below this limit. 

## Example

In the following example, the implementation in question supports 31 significant case-sensitive characters in identifiers that do not have external linkage. The identifier `engine_exhaust_gas_temperature_local` is compliant with this rule. Although it is not distinct from the identifier `engine_exhaust_gas_temperature_raw`, it is in a different scope. However, it is not compliant with Rule 5.3.

```c
/* 1234567890123456789012345678901********* Characters */
extern int32_t engine_exhaust_gas_temperature_raw;
static int32_t engine_exhaust_gas_temperature_scaled; /* Non-compliant */

void f (void)
{
    /* 1234567890123456789012345678901***** Characters */
    int32_t engine_exhaust_gas_temperature_local; /* Compliant */
}

/* 1234567890123456789012345678901********* Characters */
static int32_t engine_exhaust_gas_temp_raw;
static int32_t engine_exhaust_gas_temp_scaled; /* Compliant */

```

## See also

Dir 1.1, Rule 5.1, Rule 5.3, Rule 5.4, Rule 5.5

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
