# Rule 22.13 Thread objects, thread synchronization objects and thread-specific storage pointers shall have appropriate storage duration

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Amplification
Objects of type *thrd_t*, *mtx_t*, *cnd_t*, and *tss_t* shall not have automatic storage duration nor thread storage duration.

## Rationale
Determining the lifetime of non-static objects which depend on thread execution state is difficult and error-prone. In particular, sharing objects of automatic storage duration between threads and using them to control concurrent execution can cause undefined behaviour due to accessing them outside of their lifetime.

Usage of a static pool of synchronization resources is common practice in many safety-related operating systems, including ARINC-653 [45], AUTOSAR [46] and OSEK [47].

## Example
```c
mtx_t Ra;                            /* Compliant */

int32_t t1( void *ptr )              /* Thread entry */
{
  ...
  mtx_lock ( &Ra); 
  mtx_lock ( (mtx_t*)ptr );          /* Lifetime of Rb might have ended
                                        ... pointer might be dangling */
  ...
  mtx_unlock( (mtx_t*)ptr );         /* Lifetime of Rb might have ended
                                        ... pointer might be dangling */
  mtx_unlock( &Ra); 
}

void main( void )
{
  thrd_t id1;                        /* Non-compliant */
  mtx_t Rb;                          /* Non-compliant */

  mtx_init ( &Ra, mtx_plain );
  mtx_init ( &Rb, mtx_plain );

  thrd_create( &id1, t1, &Rb );
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].