# Rule 0–3–2 (Required) If a function generates error information, then that error information shall be tested.

## Rationale
A function (whether it is part of the standard library, a third party library or a user defined function) may provide some means of indicating the occurrence of an error. This may be via a global error flag, a parametric error flag, a special return value or some other means. Whenever such a mechanism is provided by a function the calling program shall check for the indication of an error as soon as the function returns.
Note, however, that the checking of input values to functions is considered a more robust means of error prevention than trying to detect errors after the function has completed.

## Example
```c
extern void fn3 ( int32_t i, bool & flag );
int32_t fn1 ( int32_t i ) 
{ 
 int32_t result = 0; 
 bool success = false;
 fn3 ( i, success ); // Non-compliant - success not checked 
 return result; 
}
int32_t fn2 ( int32_t i ) 
{ 
 int32_t result = 0; 
 bool success = false;
 fn3 ( i, success ); // Compliant - success checked 
 if ( !success ) 
 { 
 throw 42; 
 } 
 return result; 
}
```

## See also
Rule 19–3–1

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
