# Rule 14–8–1 (Required) Overloaded function templates shall not be explicitly specialized.

## Rationale
Explicit specializations will be considered only after overload resolution has chosen a best match from the set of primary function templates. This may be inconsistent with developer expectations.

## Example
```c
template <typename T> void f ( T ); // overload Example 1 
template <typename T> void f ( T* ); // overload Example 2
template <> void f<int32_t*> ( int32_t* ); // explicit specialization of 
 // Example 1
void b ( int32_t * i ) 
{ 
 f ( i ); // Non-compliant 
 // - Calls Example 2, f<int32_t*> 
}
```
Where a template is not overloaded with other templates, or is overloaded with non-template functions then it can be explicitly specialized, as it is consistent with developer expectation that the explicit specializations will only be considered if that primary template is chosen.
```c
template <typename T> void f ( T ); // Example 1 
template <> void f<int32_t*> ( int32_t* ); // Example 2
void b ( int32_t * i ) 
{ 
 f ( i ); // Compliant 
 // - Calls Example 2, f<int32_t*> 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
